/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.navigation;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDVisitor;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class DesignViewNavigationLocation
extends NavigationLocation {
    protected Path path;
    private static final String PATH_TAG = "path";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DesignViewNavigationLocation(IEditorPart part) {
        super(part);
        this.path = new Path();
    }

    public DesignViewNavigationLocation(IEditorPart part, XSDConcreteComponent component) {
        super(part);
        this.path = Path.computePath(component);
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        boolean result = false;
        if (currentLocation instanceof DesignViewNavigationLocation) {
            DesignViewNavigationLocation loc = (DesignViewNavigationLocation)currentLocation;
            result = loc.path.toString().equals(this.path.toString());
        }
        return result;
    }

    public void restoreLocation() {
        Object viewer;
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDSchema schema = (XSDSchema)iEditorPart.getAdapter((Class)clazz);
        IEditorPart iEditorPart2 = this.getEditorPart();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewer = iEditorPart2.getAdapter((Class)clazz2)) instanceof DesignViewGraphicalViewer) {
            Adapter adapter;
            DesignViewGraphicalViewer graphicalViewer = (DesignViewGraphicalViewer)((Object)viewer);
            XSDConcreteComponent component = Path.computeComponent(schema, this.path);
            if (component != null) {
                Adapter adapter2 = XSDAdapterFactory.getInstance().adapt((Notifier)component);
                if (adapter2 instanceof IADTObject) {
                    graphicalViewer.setInput((IADTObject)adapter2);
                }
            } else if (this.path.segments.isEmpty() && (adapter = XSDAdapterFactory.getInstance().adapt((Notifier)schema)) instanceof IADTObject) {
                graphicalViewer.setInput((IADTObject)adapter);
            }
        }
    }

    public void restoreState(IMemento memento) {
        String string = memento.getString(PATH_TAG);
        this.path = Path.createPath(string);
    }

    public void saveState(IMemento memento) {
        memento.putString(PATH_TAG, this.path.toString());
    }

    public void update() {
    }

    protected static class Path {
        private static final String REDEFINE_TOKEN = "redefine";
        private static final String MODEL_GROUP_TOKEN = "modelGroup";
        private static final String ATTRIBUTE_GROUP_TOKEN = "attributeGroup";
        private static final String TYPE_TOKEN = "type";
        private static final String ELEMENT_TOKEN = "element";
        List segments = new ArrayList();

        protected Path() {
        }

        public static XSDConcreteComponent computeComponent(XSDSchema schema, Path path) {
            PathResolvingXSDVisitor visitor = new PathResolvingXSDVisitor(path);
            visitor.visitSchema(schema);
            if (visitor.isDone()) {
                return visitor.result;
            }
            return null;
        }

        static Path createPath(String pathString) {
            Path path = new Path();
            PathSegment segment = null;
            StringTokenizer st = new StringTokenizer(pathString, "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int kind = -1;
                if (token.startsWith(ELEMENT_TOKEN)) {
                    kind = 1;
                } else if (token.startsWith(TYPE_TOKEN)) {
                    kind = 2;
                } else if (token.startsWith(ATTRIBUTE_GROUP_TOKEN)) {
                    kind = 4;
                } else if (token.startsWith(MODEL_GROUP_TOKEN)) {
                    kind = 3;
                } else if (token.startsWith(REDEFINE_TOKEN)) {
                    kind = 5;
                }
                if (kind == -1) continue;
                segment = new PathSegment();
                segment.kind = kind;
                path.segments.add(segment);
                String namePattern = "[@name='";
                int startIndex = token.indexOf(namePattern);
                if (startIndex == -1) continue;
                startIndex += namePattern.length();
                int endIndex = token.indexOf("']");
                if (endIndex == -1) continue;
                segment.name = token.substring(startIndex, endIndex);
            }
            return path;
        }

        public static Path computePath(XSDConcreteComponent component) {
            Path path = new Path();
            XSDConcreteComponent c = component;
            while (c != null) {
                PathSegment segment;
                if (c instanceof XSDConcreteComponent && (segment = Path.computePathSegment(c)) != null) {
                    path.segments.add(0, segment);
                }
                c = c.eContainer();
            }
            return path;
        }

        static PathSegment computePathSegment(XSDConcreteComponent component) {
            PathSegment pathSegment = null;
            if (component instanceof XSDElementDeclaration) {
                XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)component;
                pathSegment = new PathSegment(1, elementDeclaration.getResolvedElementDeclaration().getName());
            } else if (component instanceof XSDTypeDefinition) {
                XSDTypeDefinition typeDefinition = (XSDTypeDefinition)component;
                pathSegment = new PathSegment(2, typeDefinition.getName());
            } else if (component instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition modelGroupDefinition = (XSDModelGroupDefinition)component;
                pathSegment = new PathSegment(3, modelGroupDefinition.getName());
            } else if (component instanceof XSDAttributeGroupDefinition) {
                XSDAttributeGroupDefinition attributeGroupDefinition = (XSDAttributeGroupDefinition)component;
                pathSegment = new PathSegment(4, attributeGroupDefinition.getResolvedAttributeGroupDefinition().getName());
            } else if (component instanceof XSDRedefine) {
                XSDRedefine redefine = (XSDRedefine)component;
                pathSegment = new PathSegment(5, redefine.getSchemaLocation());
            }
            return pathSegment;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            Iterator i = this.segments.iterator();
            while (i.hasNext()) {
                PathSegment segment = (PathSegment)i.next();
                String kind = "";
                if (segment.kind == 1) {
                    kind = ELEMENT_TOKEN;
                } else if (segment.kind == 2) {
                    kind = TYPE_TOKEN;
                } else if (segment.kind == 3) {
                    kind = MODEL_GROUP_TOKEN;
                } else if (segment.kind == 4) {
                    kind = ATTRIBUTE_GROUP_TOKEN;
                } else if (segment.kind == 5) {
                    kind = REDEFINE_TOKEN;
                }
                b.append(kind);
                if (segment.name != null) {
                    b.append("[@name='" + segment.name + "']");
                }
                if (!i.hasNext()) continue;
                b.append("/");
            }
            return b.toString();
        }
    }

    static class PathResolvingXSDVisitor
    extends XSDVisitor {
        Path path;
        int index = -1;
        PathSegment segment;
        XSDConcreteComponent result = null;

        PathResolvingXSDVisitor(Path path) {
            this.path = path;
            this.incrementSegment();
        }

        boolean isDone() {
            return this.index >= this.path.segments.size();
        }

        void incrementSegment() {
            ++this.index;
            this.segment = this.index < this.path.segments.size() ? (PathSegment)this.path.segments.get(this.index) : null;
        }

        public void visitSchema(XSDSchema schema) {
            if (this.segment != null) {
                if (this.segment.kind == 1) {
                    XSDElementDeclaration elementDeclaration = schema.resolveElementDeclaration(this.segment.name);
                    if (elementDeclaration != null) {
                        this.visitElementDeclaration(elementDeclaration);
                    }
                } else if (this.segment.kind == 2) {
                    XSDTypeDefinition typeDefinition = schema.resolveTypeDefinition(this.segment.name);
                    if (typeDefinition != null) {
                        this.visitTypeDefinition(typeDefinition);
                    }
                } else if (this.segment.kind == 3) {
                    XSDModelGroupDefinition modelGroupDefinition = schema.resolveModelGroupDefinition(this.segment.name);
                    if (modelGroupDefinition != null) {
                        this.visitModelGroupDefinition(modelGroupDefinition);
                    }
                } else if (this.segment.kind == 4) {
                    XSDAttributeGroupDefinition attributeGroupDefinition = schema.resolveAttributeGroupDefinition(this.segment.name);
                    if (attributeGroupDefinition != null) {
                        this.visitAttributeGroupDefinition(attributeGroupDefinition);
                    }
                } else if (this.segment.kind == 5) {
                    Iterator iterator = schema.getContents().iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof XSDRedefine)) continue;
                        XSDRedefine redefine = (XSDRedefine)object;
                        this.visitRedefine(redefine);
                    }
                }
            }
        }

        public void visitElementDeclaration(XSDElementDeclaration element) {
            if (this.segment != null) {
                String name = element.getResolvedElementDeclaration().getName();
                if (this.segment.kind == 1 && this.isMatch(this.segment.name, name)) {
                    this.result = element;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitElementDeclaration(element);
                    }
                }
            }
        }

        public void visitTypeDefinition(XSDTypeDefinition type) {
            if (this.segment != null) {
                String name = type.getName();
                if (this.segment.kind == 2 && this.isMatch(this.segment.name, name)) {
                    this.result = type;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitTypeDefinition(type);
                    }
                }
            }
        }

        public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroup) {
            if (this.segment != null) {
                String name = modelGroup.getName();
                if (this.segment.kind == 3 && this.isMatch(this.segment.name, name)) {
                    this.result = modelGroup;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitModelGroupDefinition(modelGroup);
                    }
                }
            }
        }

        public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
            if (this.segment != null) {
                String name = attributeGroup.getName();
                if (this.segment.kind == 4 && this.isMatch(this.segment.name, name)) {
                    this.result = attributeGroup;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        super.visitAttributeGroupDefinition(attributeGroup);
                    }
                }
            }
        }

        public void visitRedefine(XSDRedefine redefine) {
            if (this.segment != null) {
                String name = redefine.getSchemaLocation();
                if (this.segment.kind == 5 && this.isMatch(this.segment.name, name)) {
                    this.result = redefine;
                    this.incrementSegment();
                    if (!this.isDone()) {
                        this.visitSchema(redefine.getSchema());
                    }
                }
            }
        }

        protected boolean isMatch(String name1, String name2) {
            return name1 != null ? name1.equals(name2) : name1 == name2;
        }
    }

    static class PathSegment {
        static final int ELEMENT = 1;
        static final int TYPE = 2;
        static final int MODEL_GROUP = 3;
        static final int ATTRIBUTE_GROUP = 4;
        static final int REDEFINE = 5;
        int kind;
        String name;

        PathSegment() {
        }

        PathSegment(int kind, String name) {
            this.kind = kind;
            this.name = name;
        }
    }
}

