/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspaceBase;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public abstract class AbstractCDOWorkspaceBase
implements InternalCDOWorkspaceBase {
    private InternalCDOWorkspace workspace;
    private Set<CDOID> ids;

    protected AbstractCDOWorkspaceBase() {
    }

    @Override
    public void init(InternalCDOWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public final InternalCDOWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public final synchronized Set<CDOID> getIDs() {
        if (this.ids == null) {
            this.ids = this.doGetIDs();
        }
        return this.ids;
    }

    @Override
    @Deprecated
    public final void updateAfterCommit(CDOTransaction transaction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final synchronized void registerChangedOrDetachedObject(InternalCDORevision revision) {
        this.getIDs().add(revision.getID());
        this.doRegisterChangedOrDetachedObject(revision);
    }

    @Override
    public final synchronized void registerAddedAndDetachedObject(InternalCDORevision revision) {
        this.doRegisterAddedAndDetachedObject(revision);
        this.deregisterObject(revision.getID());
    }

    @Override
    public final synchronized void registerAddedObject(CDOID id) {
        this.getIDs().add(id);
        this.doRegisterAddedObject(id);
    }

    @Override
    public final synchronized void deregisterObject(CDOID id) {
        if (this.ids != null) {
            this.ids.remove(id);
        }
        this.doDeregisterObject(id);
    }

    @Override
    public final synchronized void clear() {
        this.ids = new HashSet<CDOID>();
        this.doClear();
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.getIDs().isEmpty();
    }

    @Override
    public final synchronized boolean containsID(CDOID id) {
        return this.getIDs().contains(id);
    }

    protected CDODataInput createCDODataInput(ExtendedDataInputStream edis) throws IOException {
        InternalCDOPackageRegistry packageRegistry = this.workspace.getLocalRepository().getPackageRegistry(false);
        InternalCDOBranchManager branchManager = this.workspace.getLocalRepository().getBranchManager();
        CDORevisionFactory revisionFactory = CDORevisionFactory.DEFAULT;
        CDOListFactory listFactory = CDOListFactory.DEFAULT;
        return CDOCommonUtil.createCDODataInput((ExtendedDataInputStream)edis, (CDOPackageRegistry)packageRegistry, (CDOBranchManager)branchManager, null, (CDORevisionFactory)revisionFactory, (CDOListFactory)listFactory, null);
    }

    protected CDODataOutput createCDODataOutput(ExtendedDataOutputStream edos) {
        InternalRepository localRepository = this.workspace.getLocalRepository();
        InternalCDOPackageRegistry packageRegistry = localRepository.getPackageRegistry(false);
        CDOIDProvider idProvider = CDOIDProvider.NOOP;
        return CDOCommonUtil.createCDODataOutput((ExtendedDataOutput)edos, (CDOPackageRegistry)packageRegistry, (CDOIDProvider)idProvider, (CDORevisionUnchunker)localRepository);
    }

    protected abstract void doClear();

    protected abstract Set<CDOID> doGetIDs();

    protected abstract void doRegisterChangedOrDetachedObject(InternalCDORevision var1);

    protected abstract void doRegisterAddedAndDetachedObject(InternalCDORevision var1);

    protected abstract void doRegisterAddedObject(CDOID var1);

    protected abstract void doDeregisterObject(CDOID var1);
}

