/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.DomSwitch;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;

public class Dom2ResourceMapper {
    public static final Dom2ResourceMapper INSTANCE = new Dom2ResourceMapper();
    private DomSwitch<String> implClassFinderSwitch = this.createImplFinderSwitch();

    private Dom2ResourceMapper() {
    }

    public IResource findResource(EObject eObject) throws JavaModelException {
        ContractChecker.nullCheckParam((Object)eObject);
        switch (eObject.eClass().getClassifierID()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                IType type = this.findType(eObject);
                return type == null ? null : type.getResource();
            }
            case 6: {
                return this.findProject((IWebServiceProject)eObject);
            }
        }
        return null;
    }

    public IProject findProject(IWebServiceProject wsProject) {
        if (wsProject == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(wsProject.getName());
    }

    public IType findType(EObject eObject) throws JavaModelException {
        ContractChecker.nullCheckParam((Object)eObject);
        IProject project = this.findProject(DomUtil.INSTANCE.findWsProject(eObject));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String fqName = this.implClassFinderSwitch.doSwitch(eObject);
        if (javaProject == null || fqName == null) {
            return null;
        }
        return javaProject.findType(fqName);
    }

    private DomSwitch<String> createImplFinderSwitch() {
        return new DomSwitch<String>(){

            @Override
            public String caseIWebService(IWebService ws) {
                return ws.getImplementation();
            }

            @Override
            public String caseIServiceEndpointInterface(IServiceEndpointInterface sei) {
                return sei == null ? null : sei.getImplementation();
            }

            @Override
            public String caseIWebMethod(IWebMethod wm) {
                return wm == null ? null : this.caseIServiceEndpointInterface((IServiceEndpointInterface)wm.eContainer());
            }

            @Override
            public String caseIWebParam(IWebParam wp) {
                return this.caseIWebMethod((IWebMethod)wp.eContainer());
            }
        };
    }
}

