/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ElementSynchronizerImpl;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ParameterSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

public abstract class AbstractMethodSynchronizer
extends ElementSynchronizerImpl {
    private ParameterSynchronizer parameterSynchronizer = new ParameterSynchronizer(this);

    public AbstractMethodSynchronizer(IModelElementSynchronizer parent) {
        super(parent);
    }

    protected abstract void visitExposableMethods(IMethodVisitor var1, ITypeHierarchy var2, IAnnotationInspector var3) throws JavaModelException;

    public void synchronizeMethods(final IServiceEndpointInterface sei, IType seiType, IAnnotationInspector inspector) throws JavaModelException {
        final LinkedList<IWebMethod> mergedMethods = new LinkedList<IWebMethod>();
        ITypeHierarchy hierarchy = seiType.newSupertypeHierarchy(null);
        IMethodVisitor visitor = new IMethodVisitor(){

            @Override
            public void visit(IMethod method, IAnnotationInspector inspector) throws JavaModelException {
                IWebMethod wm = AbstractMethodSynchronizer.this.obtainInstance(sei, method);
                if (mergedMethods.contains(wm)) {
                    return;
                }
                AbstractMethodSynchronizer.this.mergeMethod(wm, method, inspector);
                mergedMethods.add(wm);
            }
        };
        this.visitExposableMethods(visitor, hierarchy, inspector);
        this.removeLeftMethods(sei, mergedMethods);
    }

    private IWebMethod obtainInstance(IServiceEndpointInterface sei, IMethod method) throws JavaModelException {
        for (IWebMethod wm : sei.getWebMethods()) {
            if (!this.util().calcImplementation(method).equals(wm.getImplementation())) continue;
            return wm;
        }
        IWebMethod newWebMethod = this.domFactory().createIWebMethod();
        sei.getWebMethods().add((Object)newWebMethod);
        this.util().setFeatureValue(newWebMethod, 0, this.util().calcImplementation(method));
        return newWebMethod;
    }

    private void mergeMethod(IWebMethod wm, IMethod m, IAnnotationInspector inspector) throws JavaModelException {
        String name;
        boolean excluded;
        IAnnotation wmAnnotation = inspector.inspectMethod(m, "javax.jws.WebMethod");
        if (wmAnnotation == null) {
            excluded = false;
            name = m.getElementName();
        } else {
            excluded = wmAnnotation.getPropertyValue("exclude") == null ? false : Boolean.parseBoolean(wmAnnotation.getPropertyValue("exclude"));
            String string = name = wmAnnotation.getPropertyValue("operationName") == null ? m.getElementName() : wmAnnotation.getPropertyValue("operationName");
        }
        if (!name.equals(wm.getName())) {
            this.util().setFeatureValue(wm, 1, name);
        }
        if (excluded != wm.isExcluded()) {
            this.util().setFeatureValue(wm, 3, excluded);
        }
        this.mergeSoapBinding(wm, m, inspector);
        this.parameterSynchronizer.synchronizeParameters(wm, m, inspector);
        this.resource().getSerializerFactory().adapt((Notifier)wm, IAnnotationSerializer.class);
        this.adaptToLocationInterface((EObject)wm, "javax.jws.WebMethod", wmAnnotation);
    }

    private void mergeSoapBinding(IWebMethod webMethod, IMethod method, IAnnotationInspector inspector) throws JavaModelException {
        IAnnotation sbAnnotation = inspector.inspectMethod(method, "javax.jws.soap.SOAPBinding");
        IAnnotation seiSbAnnotation = inspector.inspectType("javax.jws.soap.SOAPBinding");
        SOAPBindingStyle style = this.defineSBStyle((IAnnotation<IMethod>)sbAnnotation, (IAnnotation<IType>)seiSbAnnotation);
        if (webMethod.getSoapBindingStyle() != style) {
            webMethod.setSoapBindingStyle(style);
        }
        SOAPBindingUse use = this.defineSBUse((IAnnotation<IMethod>)sbAnnotation, (IAnnotation<IType>)seiSbAnnotation);
        if (webMethod.getSoapBindingUse() != use) {
            webMethod.setSoapBindingUse(use);
        }
        SOAPBindingParameterStyle paramStyle = this.defineSBParameterStyle((IAnnotation<IMethod>)sbAnnotation, (IAnnotation<IType>)seiSbAnnotation);
        if (webMethod.getSoapBindingParameterStyle() != paramStyle) {
            webMethod.setSoapBindingParameterStyle(paramStyle);
        }
        this.adaptToLocationInterface((EObject)webMethod, "javax.jws.soap.SOAPBinding", sbAnnotation);
    }

    private SOAPBindingStyle defineSBStyle(IAnnotation<IMethod> methodSBAnnotation, IAnnotation<IType> seiSbAnnotation) {
        String value;
        String string = value = methodSBAnnotation != null ? methodSBAnnotation.getPropertyValue("style") : null;
        if (value == null) {
            return this.defCalc().defineSBStyle(seiSbAnnotation);
        }
        if ("javax.jws.soap.SOAPBinding.SOAPBinding.Style.RPC".endsWith(value)) {
            return SOAPBindingStyle.RPC;
        }
        if ("javax.jws.soap.SOAPBinding.Style.DOCUMENT".endsWith(value)) {
            return SOAPBindingStyle.DOCUMENT;
        }
        return this.defCalc().defineSBStyle(seiSbAnnotation);
    }

    private SOAPBindingUse defineSBUse(IAnnotation<IMethod> methodSBAnnotation, IAnnotation<IType> seiSbAnnotation) {
        String value;
        String string = value = methodSBAnnotation != null ? methodSBAnnotation.getPropertyValue("use") : null;
        if (value == null) {
            return this.defCalc().defineSBUse(seiSbAnnotation);
        }
        if ("javax.jws.soap.SOAPBinding.Use.ENCODED".endsWith(value)) {
            return SOAPBindingUse.ENCODED;
        }
        if ("javax.jws.soap.SOAPBinding.Use.LITERAL".endsWith(value)) {
            return SOAPBindingUse.LITERAL;
        }
        return this.defCalc().defineSBUse(seiSbAnnotation);
    }

    private SOAPBindingParameterStyle defineSBParameterStyle(IAnnotation<IMethod> methodSBAnnotation, IAnnotation<IType> seiSbAnnotation) {
        String value;
        String string = value = methodSBAnnotation != null ? methodSBAnnotation.getPropertyValue("parameterStyle") : null;
        if (value == null) {
            return this.defCalc().defineSBParameterStyle(seiSbAnnotation);
        }
        if ("javax.jws.soap.SOAPBinding.ParameterStyle.BARE".endsWith(value)) {
            return SOAPBindingParameterStyle.BARE;
        }
        if ("javax.jws.soap.SOAPBinding.ParameterStyle.WRAPPED".endsWith(value)) {
            return SOAPBindingParameterStyle.WRAPPED;
        }
        return this.defCalc().defineSBParameterStyle(seiSbAnnotation);
    }

    private void removeLeftMethods(IServiceEndpointInterface sei, Collection<IWebMethod> mergedMethods) {
        Iterator iter = sei.getWebMethods().iterator();
        while (iter.hasNext()) {
            if (mergedMethods.contains(iter.next())) continue;
            iter.remove();
        }
    }

    protected static interface IMethodVisitor {
        public void visit(IMethod var1, IAnnotationInspector var2) throws JavaModelException;
    }
}

