/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal.util;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class CompilationUnitModifier {
    private IJavaProject mProject;
    private ICompilationUnit mCompilationUnit;
    private CompilationUnit mCompilationUnitNode;
    private Document mDocument;

    public CompilationUnitModifier(IJavaProject project, String className) throws Exception {
        this.mProject = project;
        IType type = project.findType(className);
        if (type == null) {
            throw new Exception("The class " + className + " does not exist.");
        }
        this.mCompilationUnit = type.getCompilationUnit();
        if (this.mCompilationUnit == null) {
            throw new Exception("The source code for " + className + " does not exist.");
        }
    }

    public CompilationUnitModifier(IJavaProject project, ICompilationUnit cu) throws Exception {
        this.mProject = project;
        this.mCompilationUnit = cu;
    }

    public CompilationUnitModifier(IJavaProject project, ICompilationUnit cu, CompilationUnit cuNode) throws Exception {
        this.mProject = project;
        this.mCompilationUnit = cu;
        this.mCompilationUnitNode = cuNode;
        this.getCompilationUnitNode();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.mCompilationUnit;
    }

    public CompilationUnit getCompilationUnitNode() {
        if (this.mCompilationUnitNode == null) {
            ASTParser c = ASTParser.newParser((int)3);
            c.setSource(this.mCompilationUnit);
            c.setResolveBindings(true);
            this.mCompilationUnitNode = (CompilationUnit)c.createAST(null);
        }
        if (this.mDocument == null) {
            try {
                this.mDocument = new Document(this.mCompilationUnit.getBuffer().getContents());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            this.mCompilationUnitNode.recordModifications();
        }
        return this.mCompilationUnitNode;
    }

    public void setJavaSource(String newSource) {
        try {
            this.mCompilationUnit.getBuffer().setContents(newSource);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void save() throws Exception {
        if (this.mCompilationUnitNode != null) {
            assert (this.mDocument != null);
            TextEdit edits = this.mCompilationUnitNode.rewrite((IDocument)this.mDocument, this.mProject.getOptions(true));
            edits.apply((IDocument)this.mDocument);
            String newSource = this.mDocument.get();
            this.mCompilationUnit.getBuffer().setContents(newSource);
        }
        if (this.mCompilationUnit.isWorkingCopy()) {
            this.mCompilationUnit.commitWorkingCopy(true, null);
        } else {
            this.mCompilationUnit.save(null, true);
        }
    }
}

