/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.ICodanProblemMarker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.cdt.codan.internal.core.model.CodanProblem;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemCategory;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemLocation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CodanProblemMarker
implements ICodanProblemMarker {
    private static final String PROBLEM_ARGS = "args";
    private IProblemLocation loc;
    private IProblem problem;
    private Object[] args;

    public CodanProblemMarker(IProblem problem, IProblemLocation loc, Object[] args) {
        this.problem = problem;
        this.loc = loc;
        this.args = args;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public IProblemLocation getLocation() {
        return this.loc;
    }

    @Override
    public IProblem getProblem() {
        return this.problem;
    }

    @Override
    public IResource getResource() {
        return this.loc.getFile();
    }

    @Override
    public IMarker createMarker() throws CoreException {
        IResource file = this.loc.getFile();
        int lineNumber = this.loc.getLineNumber();
        int severity = this.problem.getSeverity().intValue();
        String message = this.createMessage();
        IMarker marker = file.createMarker(this.problem.getMarkerType());
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        marker.setAttribute("lineNumber", lineNumber);
        marker.setAttribute("id", (Object)this.problem.getId());
        marker.setAttribute("charEnd", this.loc.getEndingChar());
        marker.setAttribute("charStart", this.loc.getStartingChar());
        String propArgs = CodanProblemMarker.serializeArgs(this.args);
        marker.setAttribute(PROBLEM_ARGS, (Object)propArgs);
        IProblemCategory[] cats = CodanProblemCategory.findProblemCategories(CodanProblemMarker.getProfile(file).getRoot(), this.problem.getId());
        String cat = cats.length > 0 ? cats[0].getId() : "";
        marker.setAttribute("category", (Object)cat);
        return marker;
    }

    @Override
    public String createMessage() {
        String messagePattern = this.problem.getMessagePattern();
        String message = this.problem.getId();
        if (messagePattern == null) {
            if (this.args != null && this.args.length > 0 && this.args[0] instanceof String) {
                message = (String)this.args[0];
            }
        } else {
            message = MessageFormat.format(messagePattern, this.args);
        }
        return message;
    }

    private static String serializeArgs(Object[] args) {
        if (args != null) {
            Properties prop = new Properties();
            prop.put("len", String.valueOf(args.length));
            int i = 0;
            while (i < args.length) {
                Object object = args[i];
                if (object != null) {
                    prop.put("a" + i, object.toString());
                }
                ++i;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                prop.store(bout, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bout.toString();
        }
        return "";
    }

    public static String getProblemArgument(IMarker marker, int index) {
        String[] args = CodanProblemMarker.getProblemArguments(marker);
        return args[index];
    }

    public static String[] getProblemArguments(IMarker marker) {
        String attrs = marker.getAttribute(PROBLEM_ARGS, "");
        Properties prop = new Properties();
        ByteArrayInputStream bin = new ByteArrayInputStream(attrs.getBytes());
        try {
            prop.load(bin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String len = prop.getProperty("len", "0");
        int length = Integer.valueOf(len);
        String[] args = new String[length];
        int i = 0;
        while (i < length) {
            args[i] = prop.getProperty("a" + i);
            ++i;
        }
        return args;
    }

    public static String getProblemId(IMarker marker) {
        try {
            return (String)marker.getAttribute("id");
        }
        catch (CoreException e) {
            return null;
        }
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", null);
    }

    public static CodanSeverity getSeverity(IMarker marker) {
        int sev = marker.getAttribute("severity", 0);
        return CodanSeverity.valueOf(sev);
    }

    public static ICodanProblemMarker createCodanProblemMarkerFromResourceMarker(IMarker marker) {
        CodanProblem problem = CodanProblemMarker.getProblem(marker);
        if (problem == null) {
            return null;
        }
        CodanProblemLocation loc = CodanProblemMarker.getLocation(marker);
        return new CodanProblemMarker(problem, loc, CodanProblemMarker.getProblemArguments(marker));
    }

    public static CodanProblem getProblem(IMarker marker) {
        String id = CodanProblemMarker.getProblemId(marker);
        if (id == null) {
            return null;
        }
        IResource resource = marker.getResource();
        IProblemProfile profile = CodanProblemMarker.getProfile(resource);
        CodanProblem problem = (CodanProblem)((CodanProblem)profile.findProblem(id)).clone();
        CodanSeverity sev = CodanProblemMarker.getSeverity(marker);
        problem.setSeverity(sev);
        return problem;
    }

    public static IProblemProfile getProfile(IResource resource) {
        IProblemProfile profile = CheckersRegistry.getInstance().getResourceProfile(resource);
        return profile;
    }

    public static CodanProblemLocation getLocation(IMarker marker) {
        int line = marker.getAttribute("lineNumber", -1);
        int charend = marker.getAttribute("charEnd", -1);
        int charstart = marker.getAttribute("charStart", -1);
        CodanProblemLocation loc = new CodanProblemLocation(marker.getResource(), charstart, charend, line);
        return loc;
    }

    public static void setProblemArguments(IMarker marker, String[] args) throws CoreException {
        String propArgs = CodanProblemMarker.serializeArgs(args);
        marker.setAttribute(PROBLEM_ARGS, (Object)propArgs);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
        result = 31 * result + this.problem.getId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICodanProblemMarker)) {
            return false;
        }
        CodanProblemMarker other = (CodanProblemMarker)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        if (!this.loc.equals(other.loc)) {
            return false;
        }
        return this.problem.getId().equals(other.problem.getId());
    }
}

