/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenExecutionJre {
    private final String executionJreVersionRange;
    private static final Logger log = LoggerFactory.getLogger(MavenExecutionJre.class);
    private static final String GOAL_ENFORCE = "enforce";
    private static final String ENFORCER_PLUGIN_ARTIFACT_ID = "maven-enforcer-plugin";
    private static final String ENFORCER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final ArtifactVersion DEFAULT_JAVA_VERSION = new DefaultArtifactVersion("0.0.0");

    public static Optional<MavenExecutionJre> forProject(IMavenProjectFacade project, IProgressMonitor monitor) throws CoreException {
        Optional<String> executionJreVersionRange = MavenExecutionJre.readEnforcedVersion(project, monitor);
        return executionJreVersionRange.map(MavenExecutionJre::new);
    }

    private MavenExecutionJre(String executionJreVersionRange) {
        this.executionJreVersionRange = executionJreVersionRange;
    }

    private static Optional<String> readEnforcedVersion(IMavenProjectFacade project, IProgressMonitor monitor) throws CoreException {
        List mojoExecutions = project.getMojoExecutions(ENFORCER_PLUGIN_GROUP_ID, ENFORCER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_ENFORCE});
        for (MojoExecution mojoExecution : mojoExecutions) {
            Optional<String> version = MavenExecutionJre.getRequiredJavaVersionFromEnforcerRule(project.getMavenProject(monitor), mojoExecution, monitor);
            if (!version.isPresent()) continue;
            return version;
        }
        log.debug("No 'requireJavaVersion' rule found in maven-enforcer-plugin executions for project {}", (Object)project.getProject().getName());
        return Optional.empty();
    }

    private static Optional<String> getRequiredJavaVersionFromEnforcerRule(MavenProject mavenProject, MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        List<String> parameter = List.of("rules", "requireJavaVersion", "version");
        String version = (String)((MavenImpl)MavenPlugin.getMaven()).getMojoParameterValue(mavenProject, mojoExecution, parameter, String.class, monitor);
        if (version == null) {
            return Optional.empty();
        }
        if ("8".equals(version)) {
            version = "1.8";
        }
        return Optional.of(version);
    }

    public String getExecutionJreVersionRange() {
        return this.executionJreVersionRange;
    }

    public Optional<IVMInstall> getBestMatchingVM() {
        return MavenExecutionJre.getBestMatchingVM(this.executionJreVersionRange);
    }

    public Optional<String> getBestMatchingJreContainerPath() {
        return this.getBestMatchingVM().map(vm -> JavaRuntime.newJREContainerPath((IVMInstall)vm).toPortableString());
    }

    public static Optional<IVMInstall> getBestMatchingVM(String requiredVersion) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)requiredVersion);
            List<IVMInstall> matchingJREs = MavenExecutionJre.getAllMatchingJREs(versionRange);
            if (matchingJREs.isEmpty()) {
                return Optional.empty();
            }
            Object mainVersion = versionRange.getRecommendedVersion() != null ? versionRange.getRecommendedVersion() : (versionRange.getRestrictions().size() == 1 && ((Restriction)versionRange.getRestrictions().get(0)).getUpperBound() == null ? ((Restriction)versionRange.getRestrictions().get(0)).getLowerBound() : null);
            if (mainVersion != null) {
                int nearestMajorVersion = MavenExecutionJre.getJREVersion(matchingJREs.getLast()).getMajorVersion();
                return matchingJREs.stream().filter(jre -> MavenExecutionJre.getJREVersion(jre).getMajorVersion() == nearestMajorVersion).findFirst();
            }
            return Optional.of(matchingJREs.getFirst());
        }
        catch (InvalidVersionSpecificationException ex) {
            log.warn("Invalid version range", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static List<IVMInstall> getAllMatchingJREs(VersionRange versionRange) {
        TreeMap installedJREsByVersion = new TreeMap(Comparator.reverseOrder());
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vm = iVMInstallArray[n4];
                if (MavenExecutionJre.satisfiesVersionRange(vm, versionRange)) {
                    ArtifactVersion jreVersion = MavenExecutionJre.getJREVersion(vm);
                    if (jreVersion != DEFAULT_JAVA_VERSION) {
                        installedJREsByVersion.put(jreVersion, vm);
                    } else {
                        log.debug("Skipping IVMInstall '{}' from type {} as not implementing IVMInstall2", (Object)vm.getName(), (Object)vmType.getName());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return List.copyOf(installedJREsByVersion.values());
    }

    private static boolean satisfiesVersionRange(IVMInstall jre, VersionRange versionRange) {
        ArtifactVersion jreVersion = MavenExecutionJre.getJREVersion(jre);
        if (versionRange.getRecommendedVersion() != null) {
            return jreVersion.compareTo((Object)versionRange.getRecommendedVersion()) >= 0;
        }
        return versionRange.containsVersion(jreVersion);
    }

    private static ArtifactVersion getJREVersion(IVMInstall jre) {
        IVMInstall2 jre2;
        String version;
        if (jre instanceof IVMInstall2 && (version = (jre2 = (IVMInstall2)jre).getJavaVersion()) != null) {
            return new DefaultArtifactVersion(version);
        }
        return DEFAULT_JAVA_VERSION;
    }
}

