/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class InteractionEventClassifier {
    public static boolean isEdit(InteractionEvent event) {
        return event.getKind().equals((Object)InteractionEvent.Kind.EDIT) || event.getKind().equals((Object)InteractionEvent.Kind.SELECTION) && InteractionEventClassifier.isSelectionInEditor(event);
    }

    public static boolean isSelection(InteractionEvent event) {
        return event.getKind().equals((Object)InteractionEvent.Kind.SELECTION) && !InteractionEventClassifier.isSelectionInEditor(event);
    }

    public static boolean isCommand(InteractionEvent event) {
        return event.getKind().equals((Object)InteractionEvent.Kind.COMMAND);
    }

    public static boolean isJavaEdit(InteractionEvent event) {
        return event.getKind().equals((Object)InteractionEvent.Kind.EDIT) && (event.getOriginId().contains("java") || event.getOriginId().contains("jdt.ui"));
    }

    public static boolean isJDTEvent(InteractionEvent event) {
        return (InteractionEventClassifier.isEdit(event) || InteractionEventClassifier.isSelection(event) || InteractionEventClassifier.isCommand(event)) && InteractionEventClassifier.getCleanOriginId(event).contains("jdt");
    }

    public static boolean isSelectionInEditor(InteractionEvent event) {
        return event.getOriginId().contains("Editor") || event.getOriginId().contains("editor") || event.getOriginId().contains("source");
    }

    public static String getCleanOriginId(InteractionEvent event) {
        String cleanOriginId = "";
        String originId = event.getOriginId();
        if (event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) {
            int i = 0;
            while (i < originId.length()) {
                char curChar = originId.charAt(i);
                if (curChar != '&') {
                    cleanOriginId = Character.getType(curChar) == 15 ? cleanOriginId.concat(" ") : cleanOriginId.concat(String.valueOf(curChar));
                }
                ++i;
            }
            return cleanOriginId;
        }
        return originId;
    }

    public static String formatDuration(long timeToFormatInms) {
        long timeInSeconds = timeToFormatInms / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        timeInSeconds -= minutes * 60L;
        return hours + "." + minutes;
    }
}

