/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.tracepointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TracepointActionManager {
    private static final String TRACEPOINT_ACTION_DATA = "TracepointActionManager.actionData";
    private static final TracepointActionManager fTracepointActionManager = new TracepointActionManager();
    public static final String TRACEPOINT_ACTION_DELIMITER = "%_#";
    private ArrayList<ITracepointAction> tracepointActions = null;

    private TracepointActionManager() {
    }

    public static TracepointActionManager getInstance() {
        return fTracepointActionManager;
    }

    public void addAction(ITracepointAction action) {
        this.getActions().add(action);
    }

    public void deleteAction(ITracepointAction action) {
        this.getActions().remove(action);
    }

    public ITracepointAction findAction(String name) {
        for (ITracepointAction action : this.getActions()) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return null;
    }

    public ArrayList<ITracepointAction> getActions() {
        if (this.tracepointActions == null) {
            this.tracepointActions = new ArrayList();
            this.loadActionData();
        }
        return this.tracepointActions;
    }

    private void loadActionData() {
        String actionData = GdbPlugin.getDefault().getPluginPreferences().getString(TRACEPOINT_ACTION_DATA);
        if (actionData == null || actionData.length() == 0) {
            return;
        }
        Element root = null;
        try {
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(actionData))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int entryCount = nodeList.getLength();
            int i = 0;
            while (i < entryCount) {
                Element subElement;
                String nodeName;
                Node node = nodeList.item(i);
                short type = node.getNodeType();
                if (type == 1 && (nodeName = (subElement = (Element)node).getNodeName()).equalsIgnoreCase("actionEntry")) {
                    String name = subElement.getAttribute("name");
                    if (name == null) {
                        throw new Exception();
                    }
                    String value = subElement.getAttribute("value");
                    if (value == null) {
                        throw new Exception();
                    }
                    String className = subElement.getAttribute("class");
                    if (className == null) {
                        throw new Exception();
                    }
                    ITracepointAction action = (ITracepointAction)Class.forName(className).newInstance();
                    action.setName(name);
                    action.initializeFromMemento(value);
                    this.addAction(action);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String makeUniqueActionName(String defaultName) {
        Object result = defaultName;
        ITracepointAction action = this.findAction(defaultName);
        int actionCount = 1;
        while (action != null) {
            result = defaultName + "(" + actionCount + ")";
            action = this.findAction((String)result);
            ++actionCount;
        }
        return result;
    }

    public void revertActionData() {
        this.tracepointActions = null;
    }

    public void saveActionData() {
        String actionData = "";
        try {
            DocumentBuilder docBuilder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("tracepointActionData");
            doc.appendChild(rootElement);
            for (ITracepointAction action : this.getActions()) {
                Element element = doc.createElement("actionEntry");
                element.setAttribute("name", action.getName());
                element.setAttribute("class", action.getClass().getName());
                element.setAttribute("value", action.getMemento());
                rootElement.appendChild(element);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            actionData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GdbPlugin.getDefault().getPluginPreferences().setValue(TRACEPOINT_ACTION_DATA, actionData);
        GdbPlugin.getDefault().savePluginPreferences();
    }
}

