/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ContainerFileSystemProvider
implements IImportStructureProvider {
    private final IDockerConnection connection;
    private final String containerId;

    public ContainerFileSystemProvider(IDockerConnection connection, String containerId) {
        this.connection = connection;
        this.containerId = containerId;
    }

    public List getChildren(Object element) {
        try {
            ContainerFileProxy proxy = (ContainerFileProxy)element;
            if (proxy.isFolder()) {
                return ((DockerConnection)this.connection).readContainerDirectory(this.containerId, proxy.getFullPath());
            }
        }
        catch (DockerException dockerException) {
            // empty catch block
        }
        return new ArrayList();
    }

    public InputStream getContents(Object element) {
        return null;
    }

    public String getFullPath(Object element) {
        return ((ContainerFileProxy)element).getFullPath();
    }

    public String getLabel(Object element) {
        return ((ContainerFileProxy)element).getLabel();
    }

    public boolean isFolder(Object element) {
        return ((ContainerFileProxy)element).isFolder();
    }
}

