/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.repository.internal;

import java.lang.reflect.InvocationTargetException;
import org.apache.maven.shared.transfer.repository.RepositoryManagerException;

final class Invoker {
    private Invoker() {
    }

    public static <T> T invoke(Object object, String method) throws RepositoryManagerException {
        try {
            Object invoke = object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
            return (T)invoke;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RepositoryManagerException(e.getMessage(), e);
        }
    }

    public static <T> T invoke(Object object, String method, Class<?> argClazz, Object arg) throws RepositoryManagerException {
        try {
            Class<?> objectClazz = object.getClass();
            Object invoke = objectClazz.getMethod(method, argClazz).invoke(object, arg);
            return (T)invoke;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RepositoryManagerException(e.getMessage(), e);
        }
    }

    public static Object invoke(Class<?> objectClazz, String staticMethod, Class<?> argClazz, Object arg) throws RepositoryManagerException {
        try {
            return objectClazz.getMethod(staticMethod, argClazz).invoke(null, arg);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RepositoryManagerException(e.getMessage(), e);
        }
    }
}

