/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.schema;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ant.internal.ui.dtd.IAtom;
import org.eclipse.ant.internal.ui.dtd.IModel;
import org.eclipse.ant.internal.ui.dtd.schema.AntDTDSchemaMessages;
import org.eclipse.ant.internal.ui.dtd.schema.Nfm;

public class Model
implements IModel {
    protected int fKind;
    protected int fMin = 1;
    protected int fMax = 1;
    protected int fNum = 0;
    protected IModel[] fContents;
    protected List<IModel> fContentsList;
    protected IAtom fLeaf;
    protected boolean fMixed;
    private static final IModel[] fEmptyContents = new IModel[0];
    private static final String[] fOps = new String[]{"?", ",", "|", "&", "!!!"};

    public Model(int kind) {
        this.fKind = kind;
    }

    public Model() {
        this.fKind = 0;
    }

    public void setKind(int kind) {
        this.fKind = kind;
    }

    public void setMinOccurs(int min) {
        this.fMin = min;
    }

    public void setMaxOccurs(int max) {
        this.fMax = max;
    }

    public void setContents(IModel[] contents) {
        this.fContents = contents;
    }

    public void addModel(IModel model) {
        if (this.fContents != null) {
            throw new IllegalStateException(AntDTDSchemaMessages.Model_model_may_not_be_changed);
        }
        if (this.fContentsList == null) {
            this.fContentsList = new LinkedList<IModel>();
        }
        this.fContentsList.add(model);
    }

    public void setLeaf(IAtom leaf) {
        this.fLeaf = leaf;
    }

    private Nfm qualifyNfm(Nfm nfm) {
        if (nfm == null) {
            return null;
        }
        if (this.fMin == 1 && this.fMax == 1) {
            return nfm;
        }
        if (this.fMin == 0 && this.fMax == 1) {
            return Nfm.getQuestion(nfm);
        }
        if (this.fMin == 0 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getStar(nfm);
        }
        if (this.fMin == 1 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getPlus(nfm);
        }
        if (this.fMax == 0) {
            return Nfm.getNfm(null);
        }
        if (this.fMax == Integer.MAX_VALUE) {
            return Nfm.getUnbounded(nfm, this.fMin);
        }
        return Nfm.getMinMax(nfm, this.fMin, this.fMax);
    }

    public Model shallowCopy() {
        Model copy;
        block3: {
            block2: {
                copy = new Model(this.getKind());
                copy.fMixed = this.fMixed;
                copy.fLeaf = this.fLeaf;
                if (this.fContents == null) break block2;
                copy.fContentsList = new LinkedList<IModel>();
                IModel[] iModelArray = this.fContents;
                int n = this.fContents.length;
                int n2 = 0;
                while (n2 < n) {
                    IModel content = iModelArray[n2];
                    copy.fContentsList.add(content);
                    ++n2;
                }
                break block3;
            }
            if (this.fContentsList == null) break block3;
            copy.fContentsList = new LinkedList<IModel>();
            Iterator<IModel> it = this.fContentsList.iterator();
            while (it.hasNext()) {
                copy.fContentsList.add(it.next());
            }
        }
        return copy;
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public int getMinOccurs() {
        return this.fMin;
    }

    @Override
    public int getMaxOccurs() {
        return this.fMax;
    }

    @Override
    public IModel[] getContents() {
        if (this.fContents == null) {
            if (this.fContentsList != null) {
                this.fContents = this.fContentsList.toArray(new IModel[this.fContentsList.size()]);
                this.fContentsList = null;
            } else {
                this.fContents = fEmptyContents;
            }
        }
        return this.fContents;
    }

    @Override
    public IAtom getLeaf() {
        return this.fLeaf;
    }

    @Override
    public String getOperator() {
        return fOps[this.fKind];
    }

    @Override
    public String stringRep() {
        StringBuffer buf = new StringBuffer();
        this.stringRep(buf);
        return buf.toString();
    }

    private void stringRep(StringBuffer buf) {
        switch (this.getKind()) {
            case 1: 
            case 2: {
                buf.append('(');
                Iterator<IModel> it = this.fContentsList.iterator();
                while (it.hasNext()) {
                    Model model = (Model)it.next();
                    model.stringRep(buf);
                    if (!it.hasNext()) continue;
                    buf.append(this.getOperator());
                }
                buf.append(')');
                buf.append(this.getQualifier());
                break;
            }
            case 4: {
                IAtom atom = this.getLeaf();
                buf.append(atom.getName());
                break;
            }
            default: {
                buf.append(AntDTDSchemaMessages.Model____UNKNOWN____2);
            }
        }
    }

    @Override
    public String getQualifier() {
        return this.fMin == 1 ? (this.fMax == Integer.MAX_VALUE ? "+" : "") : (this.fMax == Integer.MAX_VALUE ? "*" : "?");
    }

    @Override
    public Nfm toNfm() {
        Nfm nfm = null;
        switch (this.fKind) {
            case 1: 
            case 2: {
                IModel[] contents = this.getContents();
                if (contents == null || contents.length == 0) {
                    return null;
                }
                nfm = contents[0].toNfm();
                int i = 1;
                while (i < contents.length) {
                    Nfm tmp = contents[i].toNfm();
                    nfm = this.fKind == 1 ? Nfm.getComma(nfm, tmp) : Nfm.getOr(nfm, tmp);
                    ++i;
                }
                break;
            }
            case 4: {
                nfm = Nfm.getNfm(this.fLeaf);
                break;
            }
        }
        return this.qualifyNfm(nfm);
    }
}

