/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.validate.picl.Path;
import com.thaiopensource.validate.picl.Pattern;

abstract class PathPattern
extends Pattern {
    private final String[] names;
    private final boolean[] descendantsOrSelf;
    static final String ANY = "#any";

    PathPattern(String[] stringArray, boolean[] blArray) {
        this.names = stringArray;
        this.descendantsOrSelf = blArray;
    }

    abstract boolean isAttribute();

    @Override
    boolean matches(Path path, int n) {
        return this.isAttribute() == path.isAttribute() && this.matchSegment(path, n, path.length() - n, 0, this.names.length >> 1, false);
    }

    private boolean matchSegment(Path path, int n, int n2, int n3, int n4, boolean bl) {
        if (n4 > n2) {
            return false;
        }
        while (n4 > 0 && (bl || !this.descendantsOrSelf[n3 + n4])) {
            if (!this.matchStep(path, n + n2 - 1, n3 + n4 - 1)) {
                return false;
            }
            --n2;
            --n4;
            bl = false;
        }
        while (n4 > 0 && !this.descendantsOrSelf[n3]) {
            if (!this.matchStep(path, n, n3)) {
                return false;
            }
            ++n;
            ++n3;
            --n2;
            --n4;
        }
        if (n4 == 0) {
            return this.descendantsOrSelf[n3] || n2 == 0;
        }
        --n2;
        while (n2 >= n4) {
            if (this.matchSegment(path, n, n2, n3, n4, true)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    private boolean matchStep(Path path, int n, int n2) {
        return PathPattern.matchName(path.getNamespaceUri(n), this.names[n2 *= 2]) && PathPattern.matchName(path.getLocalName(n), this.names[n2 + 1]);
    }

    private static boolean matchName(String string, String string2) {
        if (string2 == ANY) {
            return true;
        }
        return string.equals(string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n < this.names.length) {
            if (n2 != 0) {
                stringBuffer.append(this.descendantsOrSelf[n2] ? "//" : "/");
            } else if (this.descendantsOrSelf[0]) {
                stringBuffer.append(".//");
            }
            if (this.isAttribute() && n + 2 == this.names.length) {
                stringBuffer.append('@');
            }
            if (this.names[n] == ANY) {
                stringBuffer.append('*');
            } else {
                if (this.names[n].length() != 0) {
                    stringBuffer.append('{');
                    stringBuffer.append(this.names[n]);
                    stringBuffer.append('}');
                }
                stringBuffer.append(this.names[n + 1] == ANY ? "*" : this.names[n + 1]);
            }
            n += 2;
            ++n2;
        }
        if (this.names.length == 0) {
            stringBuffer.append(this.descendantsOrSelf[0] ? ".//." : ".");
        } else if (this.descendantsOrSelf[this.descendantsOrSelf.length - 1]) {
            stringBuffer.append("//.");
        }
        return stringBuffer.toString();
    }
}

