/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.prop;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsCoreConstants;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.enums.ConstantValueUnionScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.ScoutJsEnumQuery;
import org.eclipse.scout.sdk.core.s.model.js.objects.ScoutJsObjectQuery;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsCoreDataTypesUnwrapVisitor;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertySubType;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeAssignableEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeNameEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeVisitor;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.visitor.IBreadthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class ScoutJsPropertyType {
    private static final Set<String> DATA_TYPE_NAMES_SUPPORTING_CHILD_MODELS = ScoutJsPropertyType.dataTypeNamesSupportingModels();
    private final IDataType m_dataType;
    private final ScoutJsProperty m_declaringProperty;
    private final ScoutJsPropertySubType m_subType;
    private final FinalValue<Set<IScoutJsEnum>> m_enums;
    private final FinalValue<Boolean> m_isModelSupported;
    private final FinalValue<Collection<ScoutJsProperty>> m_childProperties;

    public ScoutJsPropertyType(IDataType dataType, ScoutJsPropertySubType subType, ScoutJsProperty declaringProperty) {
        this.m_dataType = dataType;
        this.m_subType = (ScoutJsPropertySubType)((Object)Ensure.notNull((Object)((Object)subType)));
        this.m_declaringProperty = (ScoutJsProperty)Ensure.notNull((Object)declaringProperty);
        this.m_enums = new FinalValue();
        this.m_isModelSupported = new FinalValue();
        this.m_childProperties = new FinalValue();
    }

    public ScoutJsPropertyType(IDataType dataType, ScoutJsProperty declaringProperty) {
        this(dataType, ScoutJsPropertySubType.NOTHING, declaringProperty);
    }

    private static Set<String> dataTypeNamesSupportingModels() {
        HashSet<String> supportModel = new HashSet<String>(ScoutJsCoreConstants.CLASS_NAMES_MODEL_TYPES);
        supportModel.add("StatusOrModel");
        supportModel.add("GridData");
        supportModel.add("Widget");
        supportModel.add("Status");
        return Collections.unmodifiableSet(supportModel);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder(this.dataType().map(INodeElement::name).orElse("unknown"));
        if (this.subType() != ScoutJsPropertySubType.NOTHING) {
            toStringBuilder.append(" (sub-type=").append((Object)this.subType()).append(")");
        }
        return toStringBuilder.toString();
    }

    public ScoutJsPropertySubType subType() {
        return this.m_subType;
    }

    public Optional<IDataType> dataType() {
        return Optional.ofNullable(this.m_dataType);
    }

    public ScoutJsProperty declaringProperty() {
        return this.m_declaringProperty;
    }

    public boolean isClassType() {
        return this.m_dataType != null && this.m_dataType.visit((childType, l, i) -> childType instanceof IES6Class ? TreeVisitResult.TERMINATE : TreeVisitResult.CONTINUE) == TreeVisitResult.TERMINATE;
    }

    public boolean isChildModelSupported() {
        return (Boolean)this.m_isModelSupported.computeIfAbsentAndGet(() -> {
            if (this.m_dataType == null) {
                return false;
            }
            return this.m_dataType.visit((childType, l, i) -> ScoutJsPropertyType.supportsChildModel((INodeElement)childType)) == TreeVisitResult.TERMINATE;
        });
    }

    protected static TreeVisitResult supportsChildModel(INodeElement dataType) {
        if (!(dataType instanceof IES6Class)) {
            return TreeVisitResult.CONTINUE;
        }
        String name = dataType.name();
        if ("LookupCallOrModel".equals(name)) {
            return TreeVisitResult.SKIP_SUBTREE;
        }
        if (DATA_TYPE_NAMES_SUPPORTING_CHILD_MODELS.contains(name)) {
            return TreeVisitResult.TERMINATE;
        }
        return TreeVisitResult.CONTINUE;
    }

    public Optional<String> displayName() {
        return this.dataType().flatMap(ScoutJsCoreDataTypesUnwrapVisitor::unwrap).map(d -> new DataTypeNameEvaluator(ScoutJsCoreDataTypesUnwrapVisitor::unwrappedChildren).eval(d));
    }

    public Stream<ScoutJsProperty> possibleChildProperties() {
        return ((Collection)this.m_childProperties.computeIfAbsentAndGet(() -> ScoutJsPropertyType.collectPossibleProperties(this.m_dataType, this.declaringProperty().scoutJsObject().scoutJsModel()).values())).stream();
    }

    protected static Map<String, ScoutJsProperty> collectPossibleProperties(IDataType type, ScoutJsModel model) {
        if (type == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, ScoutJsProperty> collector = new LinkedHashMap<String, ScoutJsProperty>();
        type.visit((IDataTypeVisitor)new ScoutJsCoreDataTypesUnwrapVisitor((IBreadthFirstVisitor<IDataType>)((IBreadthFirstVisitor)(childType, l, i) -> {
            IES6Class clazz;
            if (childType.flavor() == IDataType.DataTypeFlavor.Intersection) {
                childType.childTypes().map(c -> ScoutJsPropertyType.collectPossibleProperties(c, model)).reduce(ScoutJsPropertyType::intersection).ifPresent(collector::putAll);
                return TreeVisitResult.SKIP_SUBTREE;
            }
            if (childType instanceof IES6Class && !(clazz = (IES6Class)childType).isEnum() && !clazz.isTypeAlias() && !clazz.isInterface()) {
                ((ScoutJsObjectQuery)((Object)((Object)((ScoutJsObjectQuery)((Object)((Object)model.findScoutObjects().withDeclaringClass(clazz)))).withIncludeDependencies(true)))).first().stream().flatMap(o -> o.findProperties().withSupers(true).stream()).forEach(p -> collector.put(p.name(), (ScoutJsProperty)p));
            }
            return TreeVisitResult.CONTINUE;
        })));
        return collector;
    }

    protected static Map<String, ScoutJsProperty> intersection(Map<String, ScoutJsProperty> a, Map<String, ScoutJsProperty> b) {
        return a.entrySet().stream().map(elementFromA -> {
            ScoutJsProperty fromB = (ScoutJsProperty)b.get(elementFromA.getKey());
            if (fromB == null) {
                return null;
            }
            return ScoutJsProperty.choose((ScoutJsProperty)elementFromA.getValue(), fromB);
        }).filter(Objects::nonNull).collect(Collectors.toMap(ScoutJsProperty::name, Function.identity(), Ensure::failOnDuplicates, LinkedHashMap::new));
    }

    public boolean isAssignableFrom(IDataType child) {
        return this.dataType().map(dt -> dt.flavor() == IDataType.DataTypeFlavor.Array ? (IDataType)dt.childTypes().findAny().orElse(null) : dt).flatMap(ScoutJsCoreDataTypesUnwrapVisitor::unwrap).filter(myType -> new DataTypeAssignableEvaluator(child, ScoutJsCoreDataTypesUnwrapVisitor::unwrappedChildren).fulfills(myType)).isPresent();
    }

    public boolean isEnumLike() {
        return !this.getScoutJsEnums().isEmpty();
    }

    public Stream<IScoutJsEnum> scoutJsEnums() {
        return this.getScoutJsEnums().stream();
    }

    protected Set<IScoutJsEnum> getScoutJsEnums() {
        return (Set)this.m_enums.computeIfAbsentAndGet(() -> this.dataType().filter(d -> d.flavor() != IDataType.DataTypeFlavor.Array).stream().flatMap(dataType -> Stream.concat(((ScoutJsEnumQuery)((Object)((Object)((Object)this.declaringProperty().scoutJsObject().scoutJsModel().findScoutEnums().withIncludeDependencies(true))))).withFulfillsDataType((IDataType)dataType).stream(), ConstantValueUnionScoutEnum.create(this.declaringProperty().scoutJsObject().scoutJsModel(), dataType).stream())).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public boolean isArray() {
        return this.m_dataType != null && this.m_dataType.flavor() == IDataType.DataTypeFlavor.Array;
    }

    public boolean isBoolean() {
        return "boolean".equals(this.dataTypeName());
    }

    public boolean isString() {
        return "string".equals(this.dataTypeName());
    }

    protected String dataTypeName() {
        return this.dataType().map(INodeElement::name).orElse(null);
    }
}

