/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public abstract class Base {
    protected static final String PROP_LOCKED = "locked";
    protected static final String PROP_PRIVATE = "private";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_ID = "id";
    protected static final String PROP_ID_SET = "id-set";
    protected static final String PROP_TIMESTAMP = "timestamp";
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected IFile file;

    public Base(IFile file) {
        this.file = file;
    }

    public Base(IFile file, String id) {
        this.file = file;
        if (id != null && id.length() > 0) {
            this.map.put(PROP_ID, id);
            this.map.put(PROP_ID_SET, Boolean.toString(true));
        }
    }

    public int getTimestamp() {
        return this.getAttribute(PROP_TIMESTAMP, -1);
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean isAttributeSet(String attributeName) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj != null) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return (String)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int getAttribute(String attributeName, int defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return Integer.parseInt((String)obj);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return Boolean.valueOf((String)obj);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public List<String> getAttribute(String attributeName, List<String> defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return (List)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Map getAttribute(String attributeName, Map defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return (Map)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String getId() {
        return this.getAttribute(PROP_ID, "");
    }

    public String getName() {
        return this.getAttribute(PROP_NAME, "");
    }

    public boolean isReadOnly() {
        return this.getAttribute(PROP_LOCKED, false);
    }

    public boolean isPrivate() {
        return this.getAttribute(PROP_PRIVATE, false);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected abstract String getXMLRoot();

    protected void save(IMemento memento) {
        IMemento child = memento;
        for (String key : this.map.keySet()) {
            Object obj = this.map.get(key);
            if (obj instanceof String) {
                child.putString(key, (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                Integer in = (Integer)obj;
                child.putInteger(key, in);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean bool = (Boolean)obj;
                child.putBoolean(key, bool);
                continue;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                this.saveList(child, key, list);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map map2 = (Map)obj;
            this.saveMap(child, key, map2);
        }
        this.saveState(child);
    }

    protected void saveMap(IMemento memento, String key, Map map2) {
        IMemento child = memento.createChild("map");
        child.putString("key", key);
        for (String s : map2.keySet()) {
            child.putString(s, (String)map2.get(s));
        }
    }

    protected void saveList(IMemento memento, String key, List list) {
        IMemento child = memento.createChild("list");
        child.putString("key", key);
        int i = 0;
        for (String s : list) {
            child.putString("value" + i++, s);
        }
    }

    protected void saveToFile(IProgressMonitor monitor) throws CoreException {
        try {
            XMLMemento memento = XMLMemento.createWriteRoot(this.getXMLRoot());
            this.save(memento);
            InputStream in = memento.getInputStream();
            if (this.file.exists()) {
                this.file.setContents(in, true, true, ProgressUtil.getSubMonitorFor(monitor, 1000));
            } else {
                this.file.create(in, true, ProgressUtil.getSubMonitorFor(monitor, 1000));
            }
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Could not save " + this.getXMLRoot(), e);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)this.getFile().toString()), (Throwable)e));
        }
    }

    protected void doSave(IProgressMonitor monitor) throws CoreException {
        if (this.file != null) {
            this.saveToFile(monitor);
        } else {
            this.saveToMetadata(monitor);
        }
        ResourceManager.getInstance().resolveServers();
    }

    protected void saveToMetadata(IProgressMonitor monitor) {
    }

    protected abstract void saveState(IMemento var1);

    protected void load(IMemento memento) {
        IMemento[] maps;
        int n;
        this.map = new HashMap<String, Object>();
        for (String key : memento.getNames()) {
            this.map.put(key, memento.getString(key));
        }
        IMemento[] children = memento.getChildren("list");
        if (children != null) {
            IMemento[] iMementoArray = children;
            n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                this.loadList(child);
                ++n2;
            }
        }
        if ((maps = memento.getChildren("map")) != null) {
            IMemento[] iMementoArray = maps;
            int n3 = maps.length;
            n = 0;
            while (n < n3) {
                IMemento m = iMementoArray[n];
                this.loadMap(m);
                ++n;
            }
        }
        this.loadState(memento);
    }

    protected void loadMap(IMemento memento) {
        String key = memento.getString("key");
        HashMap<String, String> vMap = new HashMap<String, String>();
        for (String s : memento.getNames()) {
            String v = memento.getString(s);
            vMap.put(s, v);
        }
        this.map.put(key, vMap);
    }

    protected void loadList(IMemento memento) {
        String key = memento.getString("key");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        String key2 = memento.getString("value" + i++);
        while (key2 != null) {
            list.add(key2);
            key2 = memento.getString("value" + i++);
        }
        this.map.put(key, list);
    }

    protected abstract void loadState(IMemento var1);

    protected void resolve() {
    }

    public void delete() throws CoreException {
        if (this.isWorkingCopy()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "Cannot delete a working copy", null));
        }
        if (this.file != null) {
            this.deleteFromFile();
        } else {
            this.deleteFromMetadata();
        }
    }

    protected void deleteFromFile() throws CoreException {
        this.file.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void deleteFromMetadata() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Base)) {
            return false;
        }
        Base base = (Base)obj;
        if (this.getId() == null) {
            return false;
        }
        if (!this.getId().equals(base.getId())) {
            return false;
        }
        if (this.isWorkingCopy() != base.isWorkingCopy()) {
            return false;
        }
        return !this.isWorkingCopy() || this == base;
    }

    protected void loadFromFile(IProgressMonitor monitor) throws CoreException {
        InputStream in = null;
        try {
            try {
                in = this.file.getContents();
                IMemento memento = XMLMemento.loadMemento(in);
                this.load(memento);
            }
            catch (Exception e) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Could not load from file", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorLoading, (Object)this.getFile().toString()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
    }

    protected void loadFromMemento(IMemento memento, IProgressMonitor monitor) {
        this.load(memento);
    }

    protected void loadFromPath(IPath path, IProgressMonitor monitor) throws CoreException {
        InputStream in = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(path.toFile()));
                IMemento memento = XMLMemento.loadMemento(in);
                this.load(memento);
            }
            catch (Exception e) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Could not load from path", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorLoading, (Object)path.toString()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
    }

    public IStatus validateEdit(Object context) {
        if (this.file == null) {
            return null;
        }
        return this.file.getWorkspace().validateEdit(new IFile[]{this.file}, context);
    }
}

