/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.dependencies;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.grammar.dependencies.AbsoluteRuleReference;
import org.eclipse.tm4e.core.internal.grammar.dependencies.IncludeReference;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawGrammar;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRepository;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRule;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class ScopeDependencyProcessor {
    private final Set<String> seenFullScopeRequests = new HashSet<String>();
    private final Set<String> seenPartialScopeRequests = new HashSet<String>();
    public Deque<AbsoluteRuleReference> Q = new ArrayDeque<AbsoluteRuleReference>();
    private final IGrammarRepository repo;
    private final String initialScopeName;

    public ScopeDependencyProcessor(IGrammarRepository repo, String initialScopeName) {
        this.repo = repo;
        this.initialScopeName = initialScopeName;
        this.seenFullScopeRequests.add(initialScopeName);
        this.Q.add(new AbsoluteRuleReference.TopLevelRuleReference(initialScopeName));
    }

    public void processQueue() {
        Deque<AbsoluteRuleReference> q = this.Q;
        this.Q = new ArrayDeque<AbsoluteRuleReference>();
        ExternalReferenceCollector deps = new ExternalReferenceCollector();
        for (AbsoluteRuleReference dep : q) {
            this.collectReferencesOfReference(dep, this.initialScopeName, this.repo, deps);
        }
        for (AbsoluteRuleReference dep : deps.references) {
            if (dep instanceof AbsoluteRuleReference.TopLevelRuleReference) {
                if (this.seenFullScopeRequests.contains(dep.scopeName)) continue;
                this.seenFullScopeRequests.add(dep.scopeName);
                this.Q.push(dep);
                continue;
            }
            if (this.seenFullScopeRequests.contains(dep.scopeName) || this.seenPartialScopeRequests.contains(dep.toKey())) continue;
            this.seenPartialScopeRequests.add(dep.toKey());
            this.Q.push(dep);
        }
    }

    private void collectReferencesOfReference(AbsoluteRuleReference reference, String baseGrammarScopeName, IGrammarRepository repo, ExternalReferenceCollector result) {
        IRawGrammar selfGrammar = repo.lookup(reference.scopeName);
        if (selfGrammar == null) {
            if (reference.scopeName.equals(baseGrammarScopeName)) {
                throw new TMException("No grammar provided for <" + this.initialScopeName + ">");
            }
            return;
        }
        IRawGrammar baseGrammar = NullSafetyHelper.castNonNull(repo.lookup(baseGrammarScopeName));
        if (reference instanceof AbsoluteRuleReference.TopLevelRuleReference) {
            this.collectExternalReferencesInTopLevelRule(new Context(baseGrammar, selfGrammar), result);
        } else if (reference instanceof AbsoluteRuleReference.TopLevelRepositoryRuleReference) {
            AbsoluteRuleReference.TopLevelRepositoryRuleReference ref = (AbsoluteRuleReference.TopLevelRepositoryRuleReference)reference;
            this.collectExternalReferencesInTopLevelRepositoryRule(ref.ruleName, new ContextWithRepository(baseGrammar, selfGrammar, selfGrammar.getRepository()), result);
        }
        Collection<String> injections = repo.injections(reference.scopeName);
        if (injections != null) {
            for (String injection : injections) {
                result.add(new AbsoluteRuleReference.TopLevelRuleReference(injection));
            }
        }
    }

    private void collectExternalReferencesInTopLevelRepositoryRule(String ruleName, ContextWithRepository context, ExternalReferenceCollector result) {
        IRawRule rule;
        if (context.repository != null && (rule = context.repository.getRule(ruleName)) != null) {
            this.collectExternalReferencesInRules(List.of(rule), context, result);
        }
    }

    private void collectExternalReferencesInTopLevelRule(Context context, ExternalReferenceCollector result) {
        Map<String, IRawRule> injections;
        Collection<IRawRule> patterns = context.selfGrammar.getPatterns();
        if (patterns != null) {
            this.collectExternalReferencesInRules(patterns, new ContextWithRepository(context, context.selfGrammar.getRepository()), result);
        }
        if ((injections = context.selfGrammar.getInjections()) != null) {
            this.collectExternalReferencesInRules(injections.values(), new ContextWithRepository(context, context.selfGrammar.getRepository()), result);
        }
    }

    private void collectExternalReferencesInRules(Collection<IRawRule> rules, ContextWithRepository context, ExternalReferenceCollector result) {
        for (IRawRule rule : rules) {
            String include;
            if (result.visitedRule.contains(rule)) continue;
            result.visitedRule.add(rule);
            IRawRepository patternRepository = rule.getRepository() == null ? context.repository : IRawRepository.merge(context.repository, rule.getRepository());
            Collection<IRawRule> patternPatterns = rule.getPatterns();
            if (patternPatterns != null) {
                this.collectExternalReferencesInRules(patternPatterns, new ContextWithRepository(context, patternRepository), result);
            }
            if ((include = rule.getInclude()) == null) continue;
            IncludeReference reference = IncludeReference.parseInclude(include);
            switch (reference.kind) {
                case Base: {
                    this.collectExternalReferencesInTopLevelRule(new Context(context.baseGrammar, context.baseGrammar), result);
                    break;
                }
                case Self: {
                    this.collectExternalReferencesInTopLevelRule(context, result);
                    break;
                }
                case RelativeReference: {
                    this.collectExternalReferencesInTopLevelRepositoryRule(reference.ruleName, new ContextWithRepository(context, patternRepository), result);
                    break;
                }
                case TopLevelReference: 
                case TopLevelRepositoryReference: {
                    IRawGrammar selfGrammar;
                    IRawGrammar iRawGrammar = reference.scopeName.equals(context.selfGrammar.getScopeName()) ? context.selfGrammar : (selfGrammar = reference.scopeName.equals(context.baseGrammar.getScopeName()) ? context.baseGrammar : null);
                    if (selfGrammar != null) {
                        ContextWithRepository newContext = new ContextWithRepository(context.baseGrammar, selfGrammar, patternRepository);
                        if (reference.kind == IncludeReference.Kind.TopLevelRepositoryReference) {
                            this.collectExternalReferencesInTopLevelRepositoryRule(reference.ruleName, newContext, result);
                            break;
                        }
                        this.collectExternalReferencesInTopLevelRule(newContext, result);
                        break;
                    }
                    if (reference.kind == IncludeReference.Kind.TopLevelRepositoryReference) {
                        result.add(new AbsoluteRuleReference.TopLevelRepositoryRuleReference(reference.scopeName, reference.ruleName));
                        break;
                    }
                    result.add(new AbsoluteRuleReference.TopLevelRuleReference(reference.scopeName));
                }
            }
        }
    }

    private static class Context {
        final IRawGrammar baseGrammar;
        final IRawGrammar selfGrammar;

        Context(IRawGrammar baseGrammar, IRawGrammar selfGrammar) {
            this.baseGrammar = baseGrammar;
            this.selfGrammar = selfGrammar;
        }
    }

    private static final class ContextWithRepository
    extends Context {
        final @Nullable IRawRepository repository;

        ContextWithRepository(Context context, @Nullable IRawRepository repository) {
            super(context.baseGrammar, context.selfGrammar);
            this.repository = repository;
        }

        ContextWithRepository(IRawGrammar baseGrammar, IRawGrammar selfGrammar, @Nullable IRawRepository repository) {
            super(baseGrammar, selfGrammar);
            this.repository = repository;
        }
    }

    private static class ExternalReferenceCollector {
        final Deque<AbsoluteRuleReference> references = new ArrayDeque<AbsoluteRuleReference>();
        final Deque<String> seenReferenceKeys = new ArrayDeque<String>();
        final Set<IRawRule> visitedRule = new HashSet<IRawRule>();

        private ExternalReferenceCollector() {
        }

        void add(AbsoluteRuleReference reference) {
            String key = reference.toKey();
            if (this.seenReferenceKeys.contains(key)) {
                return;
            }
            this.seenReferenceKeys.push(key);
            this.references.push(reference);
        }
    }
}

