/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.merge;

import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.internal.merge.MergeOperation;

public enum MergeMode {
    LEFT_TO_RIGHT,
    RIGHT_TO_LEFT,
    ACCEPT,
    REJECT;


    public MergeMode inverse() {
        MergeMode ret;
        switch (this) {
            case LEFT_TO_RIGHT: {
                ret = RIGHT_TO_LEFT;
                break;
            }
            case RIGHT_TO_LEFT: {
                ret = LEFT_TO_RIGHT;
                break;
            }
            case ACCEPT: {
                ret = REJECT;
                break;
            }
            case REJECT: {
                ret = ACCEPT;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ret;
    }

    public DifferenceSource getMergeTarget(boolean isLeftEditable, boolean isRightEditable) {
        DifferenceSource ret;
        switch (this) {
            case LEFT_TO_RIGHT: {
                ret = DifferenceSource.RIGHT;
                break;
            }
            case RIGHT_TO_LEFT: {
                ret = DifferenceSource.LEFT;
                break;
            }
            case ACCEPT: 
            case REJECT: {
                if (isLeftEditable) {
                    ret = DifferenceSource.LEFT;
                    break;
                }
                if (isRightEditable) {
                    ret = DifferenceSource.RIGHT;
                    break;
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ret;
    }

    public boolean isLeftToRight(boolean isLeftEditable, boolean isRightEditable) {
        return this.getMergeTarget(isLeftEditable, isRightEditable) == DifferenceSource.RIGHT;
    }

    public boolean isLeftToRight(Diff diff, boolean isLeftEditable, boolean isRightEditable) {
        boolean leftToRight = this == ACCEPT && diff.getSource() == DifferenceSource.LEFT && isLeftEditable ? true : (this == REJECT && diff.getSource() == DifferenceSource.RIGHT && isLeftEditable ? true : (this == ACCEPT && diff.getSource() == DifferenceSource.RIGHT && isRightEditable ? false : (this == REJECT && diff.getSource() == DifferenceSource.LEFT && isRightEditable ? false : this.isLeftToRight(isLeftEditable, isRightEditable))));
        return leftToRight;
    }

    public MergeOperation getMergeAction(Diff difference, boolean isLeftEditable, boolean isRightEditable) {
        MergeOperation ret;
        switch (this) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                ret = MergeOperation.MERGE;
                break;
            }
            case ACCEPT: {
                if (isLeftEditable) {
                    if (difference.getSource() == DifferenceSource.LEFT) {
                        ret = MergeOperation.MARK_AS_MERGE;
                        break;
                    }
                    ret = MergeOperation.MERGE;
                    break;
                }
                if (isRightEditable) {
                    if (difference.getSource() == DifferenceSource.LEFT) {
                        ret = MergeOperation.MERGE;
                        break;
                    }
                    ret = MergeOperation.MARK_AS_MERGE;
                    break;
                }
                throw new IllegalArgumentException();
            }
            case REJECT: {
                if (isLeftEditable) {
                    if (difference.getSource() == DifferenceSource.LEFT) {
                        ret = MergeOperation.MERGE;
                        break;
                    }
                    ret = MergeOperation.MARK_AS_MERGE;
                    break;
                }
                if (isRightEditable) {
                    if (difference.getSource() == DifferenceSource.LEFT) {
                        ret = MergeOperation.MARK_AS_MERGE;
                        break;
                    }
                    ret = MergeOperation.MERGE;
                    break;
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ret;
    }

    public static MergeMode getMergeMode(Diff diff, boolean leftEditable, boolean rightEditable) {
        if (leftEditable && rightEditable) {
            switch (diff.getState()) {
                case MERGED: {
                    switch (diff.getSource()) {
                        case LEFT: {
                            return RIGHT_TO_LEFT;
                        }
                        case RIGHT: {
                            return LEFT_TO_RIGHT;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case DISCARDED: {
                    switch (diff.getSource()) {
                        case LEFT: {
                            return LEFT_TO_RIGHT;
                        }
                        case RIGHT: {
                            return RIGHT_TO_LEFT;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            return null;
        }
        if (leftEditable || rightEditable) {
            switch (diff.getState()) {
                case MERGED: {
                    return ACCEPT;
                }
                case DISCARDED: {
                    return REJECT;
                }
            }
            return null;
        }
        throw new IllegalArgumentException();
    }
}

