/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractElementOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.Messages;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

public class AbortBuildOperation
extends AbstractElementOperation<IBuild> {
    private final IBuild build;
    private final BuildServer server;

    public AbortBuildOperation(IOperationService service, IBuild build) {
        super(service);
        Assert.isNotNull((Object)build);
        this.build = build;
        this.server = (BuildServer)build.getServer();
    }

    @Override
    protected BuildJob doCreateJob(final IBuild build) {
        return new BuildJob(NLS.bind((String)Messages.AbortBuildOperation_abortingBuild, (Object)build.getLabel())){

            @Override
            protected IStatus doExecute(IOperationMonitor progress) {
                MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, Messages.AbortBuildOperation_buildAbortFailed, null);
                try {
                    AbortBuildOperation.this.server.getBehaviour().abortBuild(build, progress);
                }
                catch (UnsupportedOperationException | CoreException e) {
                    result.add((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.AbortBuildOperation_abortingBuildFailed, (Object)build.getName()), e));
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                this.setStatus((IStatus)result);
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected List<IBuild> doSyncInitInput() {
        return Collections.singletonList(this.build);
    }
}

