/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.internal.server;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewStatus;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.internal.server.ReviewManager;
import org.eclipse.emf.cdo.session.CDOSession;

public final class ServerReviewStatemachine<REVIEW extends Review>
extends ReviewStatemachine.Server<REVIEW> {
    private final ReviewManager reviewManager;

    public ServerReviewStatemachine(ReviewManager reviewManager, boolean dropReviews) {
        super(dropReviews);
        this.reviewManager = reviewManager;
    }

    protected void handleCommitInSource(Review review) {
    }

    protected void handleCommitInTarget(Review review) {
    }

    protected ReviewStatus handleRestoreFinish(REVIEW review) {
        if (review instanceof DeliveryReview) {
            DeliveryReview deliveryReview = (DeliveryReview)review;
            Module module = deliveryReview.getModule();
            CDOSession moduleSession = this.reviewManager.getLifecycleManager().getModuleSession(module);
            boolean sourceOutdated = this.isOutdated(moduleSession, (FloatingBaseline)deliveryReview.getSourceChange(), deliveryReview.getSourceCommit());
            boolean targetOutdated = this.isOutdated(moduleSession, (FloatingBaseline)deliveryReview.getStream(), deliveryReview.getTargetCommit());
            return ReviewStatus.getOutdated((boolean)sourceOutdated, (boolean)targetOutdated);
        }
        return ReviewStatus.NEW;
    }

    private boolean isOutdated(CDOSession moduleSession, FloatingBaseline floatingBaseline, long expectedTimeStamp) {
        CDOBranch baselineBranch = floatingBaseline.getBranch().resolve(moduleSession.getBranchManager());
        long sourceLastCommit = moduleSession.getCommitInfoManager().getLastCommitOfBranch(baselineBranch, true);
        return sourceLastCommit > expectedTimeStamp;
    }
}

