/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CredentialsWizardPage
extends WizardPage {
    private Text userText;
    private Text passwordText;
    private Button useToken;

    public CredentialsWizardPage() {
        super("credentialsPage", Messages.CredentialsWizardPage_Title, null);
        this.setDescription(Messages.CredentialsWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(displayArea);
        new Label(displayArea, 0).setText(Messages.CredentialsWizardPage_LabelUser);
        this.userText = new Text(displayArea, 2052);
        this.userText.addModifyListener(e -> this.validatePage());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.userText);
        final Label passwordLabel = new Label(displayArea, 0);
        passwordLabel.setText(Messages.CredentialsWizardPage_LabelPassword);
        this.passwordText = new Text(displayArea, 0x400804);
        this.passwordText.addModifyListener(e -> this.validatePage());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.passwordText);
        this.useToken = new Button(displayArea, 32);
        this.useToken.setText(Messages.HttpRepositorySettingsPage_LabelUseToken);
        this.useToken.setToolTipText(Messages.HttpRepositorySettingsPage_TooltipUseToken);
        this.useToken.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = CredentialsWizardPage.this.useToken.getSelection();
                if (isChecked) {
                    passwordLabel.setText(Messages.HttpRepositorySettingsPage_LabelToken);
                } else {
                    passwordLabel.setText(Messages.CredentialsWizardPage_LabelPassword);
                }
                passwordLabel.requestLayout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setControl((Control)displayArea);
        this.setPageComplete(false);
    }

    private void validatePage() {
        String message = null;
        if (!this.useToken.getSelection() && this.userText.getText().trim().isEmpty()) {
            message = Messages.CredentialsWizardPage_ErrorUser;
        } else if (this.passwordText.getText().trim().isEmpty()) {
            message = this.useToken.getSelection() ? Messages.HttpRepositorySettingsPage_EnterToken : Messages.CredentialsWizardPage_ErrorPassword;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getUserName() {
        return this.userText.getText();
    }

    public String getPassword() {
        return this.passwordText.getText();
    }

    public boolean isToken() {
        return this.useToken.getSelection();
    }
}

