/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.dnd;

import java.util.Collection;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;

public class DragAttributeCommand
extends DefaultDragAndDropCommand {
    public DragAttributeCommand(Object target, float location, int operations, int operation, Collection sources) {
        super(target, location, operations, operation, sources);
    }

    public boolean canExecute() {
        for (Object source : this.sources) {
            if (source instanceof Attribute) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        DTDNode referenceNode = (DTDNode)this.target;
        DTDFile dtdFile = referenceNode.getDTDFile();
        if (referenceNode instanceof Attribute) {
            dtdFile.getDTDModel().beginRecording((Object)this, DTDUIMessages._UI_MOVE_ATTRIBUTE);
            AttributeList attList = (AttributeList)referenceNode.getParentNode();
            for (DTDNode node : this.sources) {
                if (!(node instanceof Attribute)) continue;
                attList.insertIntoModel((Object)this, (Attribute)referenceNode, (Attribute)node, this.isAfter());
                dtdFile.deleteNode((Object)this, node);
            }
            dtdFile.getDTDModel().endRecording((Object)this);
        }
    }
}

