/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataContext;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeature2;

public abstract class AbstractMetaDataEnabledFeature
implements IMetaDataEnabledFeature,
IMetaDataEnabledFeature2 {
    private MetaDataContext mdContext;
    private IModelContext sdContext;
    private IProject _project;
    private IFile _file;

    @Override
    public void setMetaDataContext(MetaDataContext context) {
        this.mdContext = context;
    }

    @Override
    public MetaDataContext getMetaDataContext() {
        return this.mdContext;
    }

    @Override
    public void setStructuredDocumentContext(IStructuredDocumentContext context) {
        this.sdContext = context;
    }

    @Override
    public IStructuredDocumentContext getStructuredDocumentContext() {
        if (this.sdContext instanceof IStructuredDocumentContext) {
            return (IStructuredDocumentContext)this.sdContext;
        }
        return null;
    }

    @Override
    public IModelContext getModelContext() {
        return this.sdContext;
    }

    @Override
    public void setModelContext(IModelContext modelContext) {
        this.sdContext = modelContext;
    }

    protected IProject getProject2() {
        if (this._project == null) {
            this._project = IStructuredDocumentContextResolverFactory2.INSTANCE.getWorkspaceContextResolver2(this.sdContext).getProject();
        }
        return this._project;
    }

    protected IFile getFile2() {
        IResource res;
        if (this._file == null && (res = IStructuredDocumentContextResolverFactory2.INSTANCE.getWorkspaceContextResolver2(this.sdContext).getResource()) instanceof IFile) {
            this._file = (IFile)res;
        }
        return this._file;
    }

    protected String getTraitValueAsString(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsString((Trait)t);
        }
        return null;
    }

    protected List getTraitValueAsListOfStrings(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsListOfStrings((Trait)t);
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean getTraitValueAsBoolean(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    private Trait getTraitForEntityUsingContext(String traitName) {
        Entity entity = this.getMetaDataContext().getEntity();
        IMetaDataDomainContext modelContext = this.getMetaDataDomainContext();
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(modelContext);
        return query.getQueryHelper().getTrait(entity, traitName);
    }

    private IMetaDataDomainContext getMetaDataDomainContext() {
        IFile file = this.getFile2();
        if (file != null) {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        }
        IProject project = this.getProject2();
        if (project != null) {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(project);
        }
        return null;
    }

    protected String getSmallIcon() {
        return this.getTraitValueAsString("small-icon");
    }

    protected ImageDescriptor getImage() {
        String smallIcon = this.getSmallIcon();
        if (smallIcon == null) {
            return null;
        }
        try {
            Trait t = this.getMetaDataContext().getTrait();
            IMetaDataSourceModelProvider provider = t.getSourceModelProvider();
            IImageDescriptorProvider ip = (IImageDescriptorProvider)provider.getAdapter(IImageDescriptorProvider.class);
            if (ip != null) {
                return ip.getImageDescriptor(smallIcon);
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }
}

