/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SystemDefinedDefaultType;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.Domain;
import org.eclipse.datatools.modelbase.sql.datatypes.NumberDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpressionDefault;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogUtils {
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String PRECISION = "PRECISION";
    private static final String LENGTH = "LENGTH";
    private static final String SCALE = "SCALE";
    private static final String RADIX = "RADIX";
    private static final String NULLABLE = "NULLABLE";
    private static final String REMARKS = "REMARKS";
    private static final String[] _colPropNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
    protected static final int RESULT_SET_STRING = 1;
    protected static ArrayList _colMetaData = new ArrayList();

    public static List getDBDatatypes(String ctg, Connection cnxn) throws SQLException {
        ArrayList<String> ret = null;
        if (cnxn != null && !cnxn.isClosed()) {
            cnxn.setCatalog(ctg);
            DatabaseMetaData dbmd = cnxn.getMetaData();
            ret = new ArrayList<String>();
            ResultSet datatypes = dbmd.getTypeInfo();
            while (datatypes.next()) {
                String s = datatypes.getString(1);
                if (s == null) continue;
                ret.add(s);
            }
        }
        return ret;
    }

    public static ResultSet getStoredProcs(String ctg_nm, String sch_nm, String proc_nm, Connection cnxn) throws SQLException {
        if (cnxn == null || cnxn.isClosed()) {
            return null;
        }
        DatabaseMetaData dbmd = null;
        ResultSet rsProcedures = null;
        dbmd = cnxn.getMetaData();
        rsProcedures = dbmd.getProcedures(ctg_nm, sch_nm, proc_nm);
        return rsProcedures;
    }

    public static List addOperationNamesToCatalog(ResultSet storedProcs) throws SQLException {
        ArrayList<String> operNames = new ArrayList<String>();
        while (storedProcs.next()) {
            String ctg = storedProcs.getString(1);
            String sch = storedProcs.getString(2);
            String sp = storedProcs.getString(3);
            int idx = sp.indexOf(59);
            if (idx > 0) {
                sp = sp.substring(0, idx);
            }
            String s = "";
            if (ctg != null && ctg.length() > 0) {
                s = String.valueOf(ctg) + ".";
            }
            if (sch != null && sch.length() > 0) {
                s = String.valueOf(s) + sch + ".";
            }
            s = String.valueOf(s) + sp;
            operNames.add(s);
        }
        return operNames;
    }

    public static ResultSet getTables(String ctg_nm, String sch_nm, String table_nm, Connection cnxn) throws SQLException {
        if (cnxn == null || cnxn.isClosed()) {
            return null;
        }
        DatabaseMetaData dbmd = null;
        ResultSet rsTables = null;
        dbmd = cnxn.getMetaData();
        rsTables = dbmd.getTables(ctg_nm, sch_nm, null, null);
        return rsTables;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean getSPMetaData(Connection cxn, String catalog, String schema, String spName) {
        block5: {
            fret = true;
            tmp = null;
            try {
                sp_cols = cxn.getMetaData().getProcedureColumns(catalog, schema, spName, null);
                while (sp_cols.next()) {
                    props = new Properties();
                    idx = 0;
                    while (idx < SybaseASACatalogUtils._colPropNames.length) {
                        tmp = SybaseASACatalogUtils.getResultSetData(sp_cols, idx + 1, 1);
                        props.setProperty(SybaseASACatalogUtils._colPropNames[idx], tmp);
                        ++idx;
                    }
                    SybaseASACatalogUtils._colMetaData.add(props);
                }
                break block5;
            }
            catch (SQLException sqlx) {
                ex_msg = "";
                ** while (sqlx != null)
            }
lbl-1000:
            // 1 sources

            {
                ex_msg = String.valueOf(ex_msg) + "\n" + sqlx.getLocalizedMessage();
                sqlx = sqlx.getNextException();
                continue;
            }
lbl24:
            // 1 sources

            System.out.println(ex_msg);
            fret = false;
        }
        return fret;
    }

    protected static String getResultSetData(ResultSet rslt_set, int col_index, int rslt_set_col_type) throws SQLException {
        String ret = "";
        ret = rslt_set.getString(col_index);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static synchronized String retrieveRoutineObjectCode(Connection conn, String schemaName, String routineName) throws SQLException {
        String sql;
        String code = "";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long id = 0L;
        try {
            sql = "SELECT P.proc_id FROM SYS.SYSPROCEDURE P JOIN SYS.SYSUSERPERMS U ON U.user_id = P.creator AND U.user_name=? AND P.proc_name=?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, schemaName);
            stmt.setString(2, routineName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {}
        try {
            sql = "select proc_defn from sysprocedure where proc_id=?";
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                code = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {}
        return code;
    }

    public static synchronized String retrieveTriggerObjectCode(Connection conn, String tableSchemaName, String tableName, String schemaName, String routineName) throws SQLException {
        String sql;
        String code = "";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int trigger_id = 0;
        long table_id = 0L;
        try {
            sql = "SELECT T.trigger_id, T.table_id FROM SYS.SYSTRIGGER T JOIN SYS.SYSTABLE A ON T.table_id = A.table_id JOIN SYS.SYSUSERPERMS U on A.creator = U.user_id WHERE T.trigger_name = ? AND A.table_name = ? AND U.user_name = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, routineName);
            stmt.setString(2, tableName);
            stmt.setString(3, schemaName);
            ResultSet set = stmt.executeQuery();
            if (set.next()) {
                trigger_id = set.getInt(1);
                table_id = set.getLong(2);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {}
        try {
            sql = "SELECT trigger_defn FROM SYS.SYSTRIGGER WHERE trigger_id=? AND table_id=?";
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, trigger_id);
            stmt.setLong(2, table_id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                code = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {}
        return code;
    }

    public static void cleanupJDBCResouce(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public static Object findElement(Collection collection, String name) {
        SQLObject object = null;
        for (SQLObject sqlObject : collection) {
            if (!sqlObject.getName().equals(name)) continue;
            object = sqlObject;
            break;
        }
        return object;
    }

    public static Object findElement(Collection collection, String name, EClass metaclass) {
        SQLObject object = null;
        for (SQLObject sqlObject : collection) {
            if (!sqlObject.getName().equals(name) || !metaclass.isSuperTypeOf(sqlObject.eClass())) continue;
            object = sqlObject;
            break;
        }
        return object;
    }

    public static List getSpecifiedColumns(String colListStr, Collection columnList) {
        ArrayList<Column> result = new ArrayList<Column>();
        List columnNameList = SybaseASACatalogUtils.parseColumnList(colListStr);
        int i = 0;
        while (i < columnNameList.size()) {
            String colName = (String)columnNameList.get(i);
            Column column = (Column)SybaseASACatalogUtils.findElement(columnList, colName);
            if (column != null) {
                result.add(column);
            }
            ++i;
        }
        return result;
    }

    public static List parseColumnList(String columnListStr) {
        ArrayList<String> results = new ArrayList<String>();
        int index = -1;
        while ((index = columnListStr.indexOf(" #$% ")) != -1) {
            String columnName = columnListStr.substring(0, index);
            results.add(columnName);
            columnListStr = columnListStr.substring(index + " #$% ".length());
        }
        results.add(columnListStr);
        return results;
    }

    public static char getCharValue(String value) {
        char c = value != null && value.length() > 0 ? value.charAt(0) : (char)'\u0000';
        return c;
    }

    public static PredefinedDataType getASAPredefinedType(int width, int scale, String typeName, DatabaseDefinition databaseDefinition) throws SQLException {
        EStructuralFeature feature;
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
        PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
        if (typeDefinition == null) {
            return type;
        }
        if (typeDefinition.isLengthSupported()) {
            feature = type.eClass().getEStructuralFeature("length");
            type.eSet(feature, (Object)width);
        }
        if (typeDefinition.isScaleSupported()) {
            feature = type.eClass().getEStructuralFeature("scale");
            type.eSet(feature, (Object)scale);
        }
        if (typeDefinition.isPrecisionSupported()) {
            feature = type.eClass().getEStructuralFeature("precision");
            type.eSet(feature, (Object)width);
        }
        return type;
    }

    public static boolean isSystemDefault(String defaultValue) {
        SystemDefinedDefaultType sddt = SystemDefinedDefaultType.get((String)defaultValue.toUpperCase());
        if (sddt != null) {
            return true;
        }
        Pattern p = Pattern.compile("global autoincrement\\(\\d+\\)");
        Matcher m = p.matcher(defaultValue);
        return m.matches();
    }

    public static Domain getSpecifiedUserDefinedDatatype(Database database, String typeName) {
        Domain type = null;
        EList schemaList = database.getSchemas();
        int i = 0;
        while (i < schemaList.size()) {
            Schema schema = (Schema)schemaList.get(i);
            type = (Domain)SybaseASACatalogUtils.findElement((Collection)schema.getUserDefinedTypes(), typeName);
            if (type != null) break;
            ++i;
        }
        return type;
    }

    public static void parseView(ViewTable view, String viewText) {
        String body = viewText;
        Pattern pattern = Pattern.compile(".*[\\s]+?AS[\\s]+?([(\\s]*SELECT.*)", 34);
        Matcher matcher = pattern.matcher(viewText);
        if (matcher.matches()) {
            body = matcher.group(1);
            pattern = Pattern.compile("(.*)[ \t]+?WITH[ \t]+?.*", 34);
            matcher = pattern.matcher(body);
            if (matcher.matches()) {
                body = matcher.group(1).trim();
            }
        }
        QueryExpressionDefault queryExpression = SQLExpressionsFactory.eINSTANCE.createQueryExpressionDefault();
        queryExpression.setSQL(body);
        view.setQueryExpression((QueryExpression)queryExpression);
    }

    public static List parseOrderList(String orderListStr) {
        ArrayList<String> results = new ArrayList<String>();
        int index = -1;
        while ((index = orderListStr.indexOf(" , ")) != -1) {
            String columnName = orderListStr.substring(0, index);
            results.add(columnName);
            orderListStr = orderListStr.substring(index + " , ".length());
        }
        results.add(orderListStr);
        return results;
    }

    public static PredefinedDataType getPredefinedRepresentation(DataType datatype) {
        if (datatype instanceof DistinctUserDefinedType) {
            DistinctUserDefinedType udt = (DistinctUserDefinedType)datatype;
            PredefinedDataType pType = udt.getPredefinedRepresentation();
            return pType;
        }
        return null;
    }

    public static boolean isNumericType(DataType datatype) {
        if (SybaseASACatalogUtils.getPredefinedRepresentation(datatype) != null) {
            return SybaseASACatalogUtils.isNumericType((DataType)SybaseASACatalogUtils.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof NumericalDataType || datatype instanceof NumberDataType;
    }

    public static boolean isStringType(DataType datatype) {
        if (SybaseASACatalogUtils.getPredefinedRepresentation(datatype) != null) {
            return SybaseASACatalogUtils.isStringType((DataType)SybaseASACatalogUtils.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof CharacterStringDataType;
    }

    public static boolean isTimeType(DataType datatype) {
        if (SybaseASACatalogUtils.getPredefinedRepresentation(datatype) != null) {
            return SybaseASACatalogUtils.isTimeType((DataType)SybaseASACatalogUtils.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof TimeDataType;
    }

    public static boolean isDateType(DataType datatype) {
        if (SybaseASACatalogUtils.getPredefinedRepresentation(datatype) != null) {
            return SybaseASACatalogUtils.isDateType((DataType)SybaseASACatalogUtils.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof DateDataType;
    }

    public static boolean isBinaryType(DataType datatype) {
        if (SybaseASACatalogUtils.getPredefinedRepresentation(datatype) != null) {
            return SybaseASACatalogUtils.isBinaryType((DataType)SybaseASACatalogUtils.getPredefinedRepresentation(datatype));
        }
        return datatype instanceof BinaryStringDataType;
    }
}

