/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;

class PackagesViewTableViewer
extends ProblemTableViewer
implements IPackagesViewViewer {
    public PackagesViewTableViewer(Composite parent, int style) {
        super(parent, style);
        ColoredViewersManager.install((StructuredViewer)this);
    }

    @Override
    public void mapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.addToMap(fragment, (Item)item);
                ++i;
            }
        }
        super.mapElement(element, item);
    }

    @Override
    public void unmapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.removeFromMap(fragment, (Item)item);
                ++i;
            }
        }
        super.unmapElement(element, item);
    }

    protected Object[] getFilteredChildren(Object parent) {
        Object[] result = this.getRawChildren(parent);
        ArrayList<Object> list = new ArrayList<Object>();
        if (result != null) {
            Object[] toBeFiltered = new Object[1];
            int i = 0;
            while (i < result.length) {
                Object object = result[i];
                if (object instanceof LogicalPackage) {
                    if (this.selectLogicalPackage((LogicalPackage)((Object)object))) {
                        list.add(object);
                    }
                } else {
                    toBeFiltered[0] = object;
                    if (this.filter(toBeFiltered).length == 1) {
                        list.add(object);
                    }
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private boolean selectLogicalPackage(LogicalPackage logicalPackage) {
        return this.filter(logicalPackage.getFragments()).length > 0;
    }

    @Override
    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    @Override
    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    @Override
    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    @Override
    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    @Override
    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    @Override
    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

