/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorIds;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class SingleNameReference
extends NameReference
implements ISingleNameReference,
OperatorIds {
    public char[] token;

    public SingleNameReference(char[] source, long pos) {
        this(source, (int)(pos >>> 32), (int)pos);
    }

    public SingleNameReference(char[] source, int sourceStart, int sourceEnd) {
        this.token = source;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public char[] getToken() {
        return this.token;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        LocalVariableBinding localBinding;
        boolean isReachable;
        boolean bl = isReachable = (flowInfo.tagBits & 1) == 0;
        if (isCompound) {
            switch (this.bits & 0xF) {
                case 1: {
                    break;
                }
                case 2: {
                    localBinding = null;
                    if (this.binding instanceof LocalVariableBinding && !flowInfo.isDefinitelyAssigned(localBinding = (LocalVariableBinding)this.binding) && localBinding.declaringScope instanceof MethodScope) {
                        currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                    }
                    if (localBinding == null) break;
                    if (isReachable) {
                        localBinding.useFlag = 1;
                        break;
                    }
                    if (localBinding.useFlag != 0) break;
                    localBinding.useFlag = 2;
                }
            }
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        switch (this.bits & 0xF) {
            case 1: {
                break;
            }
            case 2: {
                if (!(this.binding instanceof LocalVariableBinding)) break;
                localBinding = (LocalVariableBinding)this.binding;
                this.bits = !flowInfo.isDefinitelyAssigned(localBinding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
                if ((localBinding.tagBits & 0x400L) != 0L) {
                    currentScope.problemReporter().parameterAssignment(localBinding, this);
                }
                flowInfo.markAsDefinitelyAssigned(localBinding);
            }
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 0xF) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                if (!(this.binding instanceof LocalVariableBinding)) break;
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!(CharOperation.equals(localBinding.name, new char[]{'a', 'r', 'g', 'u', 'm', 'e', 'n', 't', 's'}) && localBinding.declaringScope instanceof MethodScope || flowInfo.isDefinitelyAssigned(localBinding))) {
                    if (localBinding.declaringScope instanceof MethodScope) {
                        currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                    } else if (localBinding.isSameCompilationUnit(currentScope)) {
                        currentScope.problemReporter().uninitializedGlobalVariable(localBinding, this);
                    }
                }
                if ((flowInfo.tagBits & 1) == 0) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        if (valueRequired) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF0;
        this.bits |= 1;
        MethodScope methodScope = scope.methodScope();
        boolean isStatic = fieldBinding.isStatic();
        if (!(isStatic || methodScope == null || !methodScope.isStatic || fieldBinding.declaringClass != null && fieldBinding.declaringClass.equals(scope.compilationUnitScope().superBinding))) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = Constant.NotAConstant;
            return fieldBinding.type;
        }
        if (this.isFieldUseDeprecated(fieldBinding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        return fieldBinding.type;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    @Override
    public LocalVariableBinding localVariableBinding() {
        switch (this.bits & 0xF) {
            case 1: {
                break;
            }
            case 2: {
                if (!(this.binding instanceof LocalVariableBinding)) break;
                return (LocalVariableBinding)this.binding;
            }
        }
        return null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            if ((this.bits & 0x1FE0) == 0 || this.constant != Constant.NotAConstant) {
                return;
            }
            if ((this.bits & 0xF) == 2 && this.binding instanceof LocalVariableBinding) {
                currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
            }
        }
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != Constant.NotAConstant) {
            return -1;
        }
        switch (this.bits & 0xF) {
            case 1: {
                return 0;
            }
            case 2: {
                LocalVariableBinding local;
                if (!(this.binding instanceof LocalVariableBinding) || (local = (LocalVariableBinding)this.binding) == null) break;
                if (flowInfo.isDefinitelyNull(local)) {
                    return 1;
                }
                if (flowInfo.isDefinitelyNonNull(local)) {
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append(this.token);
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        return this.resolveType(scope, false, null);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope, boolean define, TypeBinding useType) {
        this.constant = Constant.NotAConstant;
        this.binding = this.findBinding(scope);
        if (define && (!this.binding.isValidBinding() || this.binding.kind() == 8)) {
            LocalDeclaration localDeclaration = new LocalDeclaration(this.token, this.sourceStart, this.sourceEnd);
            LocalVariableBinding localBinding = new LocalVariableBinding(localDeclaration, (TypeBinding)TypeBinding.UNKNOWN, 0, false);
            scope.compilationUnitScope().addLocalVariable(localBinding);
            this.binding = localBinding;
        }
        if (this.binding == null || !this.binding.isValidBinding()) {
            char[] typeName = InferEngine.createAnonymousGlobalTypeName(this.token);
            this.binding = scope.getBinding(typeName, (4 | this.bits) & 0xF, (InvocationSite)this, true);
        }
        if (this.binding.isValidBinding()) {
            switch (this.bits & 0xF) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    if (this.binding instanceof VariableBinding) {
                        TypeBinding fieldType;
                        VariableBinding variable = (VariableBinding)this.binding;
                        if (this.binding instanceof LocalVariableBinding) {
                            this.bits &= 0xFFFFFFF0;
                            this.bits |= 2;
                            fieldType = variable.type;
                            if (useType != null && useType.id != 12 && useType.id != 13 && useType.id != 0) {
                                if (define) {
                                    fieldType = variable.type = useType;
                                } else if (fieldType == TypeBinding.UNKNOWN) {
                                    fieldType = variable.type = useType;
                                } else if (!fieldType.isCompatibleWith(useType)) {
                                    fieldType = variable.type = TypeBinding.ANY;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            this.resolvedType = fieldType;
                            return this.resolvedType;
                        }
                        fieldType = this.checkFieldAccess(scope);
                        if (fieldType.isAnonymousType()) {
                            this.bits |= 4;
                        }
                        this.resolvedType = fieldType;
                        return this.resolvedType;
                    }
                    if (this.binding instanceof MethodBinding) {
                        return ((MethodBinding)this.binding).functionTypeBinding;
                    }
                    this.bits &= 0xFFFFFFF0;
                    this.bits |= 4;
                }
                case 4: {
                    this.constant = Constant.NotAConstant;
                    TypeBinding type = null;
                    switch (this.binding.kind()) {
                        case 3: {
                            type = ((VariableBinding)this.binding).type;
                            break;
                        }
                        case 8: {
                            type = ((MethodBinding)this.binding).returnType;
                            break;
                        }
                        case 4: {
                            type = (TypeBinding)this.binding;
                        }
                    }
                    if (type == null) break;
                    if (this.isTypeUseDeprecated(type, scope)) {
                        scope.problemReporter().deprecatedType(type, this);
                    }
                    this.resolvedType = type;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public Binding findBinding(BlockScope scope) {
        return scope.getBinding(this.token, (0xC | this.bits) & 0xF, (InvocationSite)this, true);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public String unboundReferenceErrorName() {
        return new String(this.token);
    }

    @Override
    public TypeBinding resolveForAllocation(BlockScope scope, ASTNode location) {
        char[] memberName = this.token;
        TypeBinding typeBinding = null;
        this.binding = scope.getBinding(memberName, (0xC | this.bits) & 0xF, (InvocationSite)this, true);
        if (this.binding instanceof TypeBinding) {
            typeBinding = (TypeBinding)this.binding;
        } else if (this.binding instanceof MethodBinding) {
            typeBinding = ((MethodBinding)this.binding).returnType;
        } else if (this.binding != null && !this.binding.isValidBinding()) {
            typeBinding = new ProblemReferenceBinding(memberName, null, this.binding.problemId());
        }
        return typeBinding;
    }

    @Override
    public int getASTType() {
        return 95;
    }
}

