/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.terminal.internal.model.ISnapshotChanges;
import org.eclipse.terminal.internal.model.SnapshotChanges;
import org.eclipse.terminal.internal.model.TerminalTextData;
import org.eclipse.terminal.internal.model.TerminalTextDataWindow;
import org.eclipse.terminal.model.ITerminalTextData;
import org.eclipse.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.terminal.model.LineSegment;
import org.eclipse.terminal.model.TerminalStyle;

class TerminalTextDataSnapshot
implements ITerminalTextDataSnapshot {
    volatile ISnapshotChanges fCurrentChanges;
    ISnapshotChanges fFutureChanges;
    final TerminalTextData fTerminal;
    final TerminalTextDataWindow fSnapshot;
    private ITerminalTextDataSnapshot.SnapshotOutOfDateListener[] fListener = new ITerminalTextDataSnapshot.SnapshotOutOfDateListener[0];
    private boolean fListenersNeedNotify;
    private int fInterestWindowSize;
    private int fInterestWindowStartLine;

    TerminalTextDataSnapshot(TerminalTextData terminal) {
        this.fSnapshot = new TerminalTextDataWindow();
        this.fTerminal = terminal;
        this.fCurrentChanges = new SnapshotChanges(this.fTerminal.getHeight());
        this.fCurrentChanges.setTerminalChanged();
        this.fFutureChanges = new SnapshotChanges(this.fTerminal.getHeight());
        this.fFutureChanges.markLinesChanged(0, this.fTerminal.getHeight());
        this.fListenersNeedNotify = true;
        this.fInterestWindowSize = -1;
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    @Override
    public void detach() {
        this.fTerminal.removeSnapshot(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutOfDate() {
        TerminalTextData terminalTextData = this.fTerminal;
        synchronized (terminalTextData) {
            return this.fFutureChanges.hasChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSnapshot(boolean detectScrolling) {
        TerminalTextData terminalTextData = this.fTerminal;
        synchronized (terminalTextData) {
            this.fCurrentChanges = this.fFutureChanges;
            this.fFutureChanges = new SnapshotChanges(this.fTerminal.getHeight());
            this.fFutureChanges.setInterestWindow(this.fInterestWindowStartLine, this.fInterestWindowSize);
            if (this.fSnapshot.getHeight() != this.fTerminal.getHeight() || this.fSnapshot.getWidth() != this.fTerminal.getWidth()) {
                if (this.fInterestWindowSize == -1) {
                    this.fSnapshot.setWindow(0, this.fTerminal.getHeight());
                }
                this.fSnapshot.copy(this.fTerminal);
                this.fCurrentChanges.setAllChanged(this.fTerminal.getHeight());
            } else {
                int start = this.fCurrentChanges.getScrollWindowStartLine();
                int lines = Math.min(this.fCurrentChanges.getScrollWindowSize(), this.fSnapshot.getHeight() - start);
                this.fSnapshot.scroll(start, lines, this.fCurrentChanges.getScrollWindowShift());
                this.fCurrentChanges.copyChangedLines(this.fSnapshot, this.fTerminal);
            }
            this.fListenersNeedNotify = true;
            this.fSnapshot.setCursorLine(this.fTerminal.getCursorLine());
            this.fSnapshot.setCursorColumn(this.fTerminal.getCursorColumn());
        }
        if (!detectScrolling) {
            this.fCurrentChanges.convertScrollingIntoChanges();
        }
    }

    @Override
    public char getChar(int line, int column) {
        return this.fSnapshot.getChar(line, column);
    }

    @Override
    public int getHeight() {
        return this.fSnapshot.getHeight();
    }

    @Override
    public LineSegment[] getLineSegments(int line, int column, int len) {
        return this.fSnapshot.getLineSegments(line, column, len);
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        return this.fSnapshot.getStyle(line, column);
    }

    @Override
    public int getWidth() {
        return this.fSnapshot.getWidth();
    }

    @Override
    public int getFirstChangedLine() {
        return this.fCurrentChanges.getFirstChangedLine();
    }

    @Override
    public int getLastChangedLine() {
        return this.fCurrentChanges.getLastChangedLine();
    }

    @Override
    public boolean hasLineChanged(int line) {
        return this.fCurrentChanges.hasLineChanged(line);
    }

    @Override
    public boolean hasDimensionsChanged() {
        return this.fCurrentChanges.hasDimensionsChanged();
    }

    @Override
    public boolean hasTerminalChanged() {
        return this.fCurrentChanges.hasTerminalChanged();
    }

    @Override
    public int getScrollWindowStartLine() {
        return this.fCurrentChanges.getScrollWindowStartLine();
    }

    @Override
    public int getScrollWindowSize() {
        return this.fCurrentChanges.getScrollWindowSize();
    }

    @Override
    public int getScrollWindowShift() {
        return this.fCurrentChanges.getScrollWindowShift();
    }

    void markLineChanged(int line) {
        this.fFutureChanges.markLineChanged(line);
        this.fFutureChanges.setTerminalChanged();
        this.notifyListers();
    }

    void markLinesChanged(int line, int n) {
        this.fFutureChanges.markLinesChanged(line, n);
        this.fFutureChanges.setTerminalChanged();
        this.notifyListers();
    }

    void markDimensionsChanged() {
        this.fFutureChanges.markDimensionsChanged();
        this.fFutureChanges.setTerminalChanged();
        this.notifyListers();
    }

    void markCursorChanged() {
        this.fFutureChanges.markCursorChanged();
        this.fFutureChanges.setTerminalChanged();
        this.notifyListers();
    }

    void scroll(int startLine, int size, int shift) {
        this.fFutureChanges.scroll(startLine, size, shift);
        this.fFutureChanges.setTerminalChanged();
        this.notifyListers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListers() {
        TerminalTextData terminalTextData = this.fTerminal;
        synchronized (terminalTextData) {
            if (this.fListenersNeedNotify) {
                int i = 0;
                while (i < this.fListener.length) {
                    this.fListener[i].snapshotOutOfDate(this);
                    ++i;
                }
                this.fListenersNeedNotify = false;
            }
        }
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        return this.fSnapshot.makeSnapshot();
    }

    @Override
    public synchronized void addListener(ITerminalTextDataSnapshot.SnapshotOutOfDateListener listener) {
        ArrayList<ITerminalTextDataSnapshot.SnapshotOutOfDateListener> list = new ArrayList<ITerminalTextDataSnapshot.SnapshotOutOfDateListener>();
        list.addAll(Arrays.asList(this.fListener));
        list.add(listener);
        this.fListener = list.toArray(new ITerminalTextDataSnapshot.SnapshotOutOfDateListener[list.size()]);
    }

    @Override
    public synchronized void removeListener(ITerminalTextDataSnapshot.SnapshotOutOfDateListener listener) {
        ArrayList<ITerminalTextDataSnapshot.SnapshotOutOfDateListener> list = new ArrayList<ITerminalTextDataSnapshot.SnapshotOutOfDateListener>();
        list.addAll(Arrays.asList(this.fListener));
        list.remove(listener);
        this.fListener = list.toArray(new ITerminalTextDataSnapshot.SnapshotOutOfDateListener[list.size()]);
    }

    public String toString() {
        return this.fSnapshot.toString();
    }

    @Override
    public int getInterestWindowSize() {
        return this.fInterestWindowSize;
    }

    @Override
    public int getInterestWindowStartLine() {
        return this.fInterestWindowStartLine;
    }

    @Override
    public void setInterestWindow(int startLine, int size) {
        assert (startLine >= 0 || this.throwRuntimeException());
        assert (size >= 0 || this.throwRuntimeException());
        this.fInterestWindowStartLine = startLine;
        this.fInterestWindowSize = size;
        this.fSnapshot.setWindow(startLine, size);
        this.fFutureChanges.setInterestWindow(startLine, size);
        this.notifyListers();
    }

    @Override
    public char[] getChars(int line) {
        return this.fSnapshot.getChars(line);
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        return this.fSnapshot.getStyles(line);
    }

    @Override
    public int getCursorColumn() {
        return this.fSnapshot.getCursorColumn();
    }

    @Override
    public int getCursorLine() {
        return this.fSnapshot.getCursorLine();
    }

    @Override
    public ITerminalTextData getTerminalTextData() {
        return this.fTerminal;
    }

    @Override
    public boolean isWrappedLine(int line) {
        return this.fSnapshot.isWrappedLine(line);
    }
}

