/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.provider.rdbschema;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.DerivedTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class AvailableTablesTreeProvider
extends LabelProvider
implements ITreeContentProvider {
    private List fSchemaList;
    SQLDomainModel domainModel;

    public AvailableTablesTreeProvider(List schemaList, SQLDomainModel domainModel) {
        this.fSchemaList = schemaList;
        this.domainModel = domainModel;
        if (this.fSchemaList == null) {
            this.fSchemaList = new ArrayList();
        }
        Iterator schemaListIter = this.fSchemaList.iterator();
        while (schemaListIter.hasNext()) {
            Schema schema = (Schema)schemaListIter.next();
            if (!schema.getName().equals("NULLID") || schema.getTables().size() != 0) continue;
            schemaListIter.remove();
        }
    }

    public Object[] getChildren(Object parentElement) {
        QuerySelectStatement selectStmt;
        QueryExpressionRoot qRoot;
        ArrayList<TableCorrelation> childList = this.fSchemaList;
        EList withTables = new ArrayList();
        QueryStatement stmt = this.domainModel.getSQLStatement();
        if (stmt instanceof QuerySelectStatement && (qRoot = (selectStmt = (QuerySelectStatement)stmt).getQueryExpr()) != null && (withTables = qRoot.getWithClause()).size() > 0) {
            SQLQueryModelFactory queryFactory = SQLQueryModelFactory.eINSTANCE;
            TableCorrelation tableCorr = queryFactory.createTableCorrelation();
            tableCorr.setName(Messages._UI_AVAILABLE_TABLES_TREE_PROVIDER);
            childList.add(tableCorr);
        }
        if (parentElement instanceof TableCorrelation) {
            childList = new ArrayList<TableCorrelation>();
            stmt = this.domainModel.getSQLStatement();
            if (stmt instanceof QuerySelectStatement && (qRoot = (selectStmt = (QuerySelectStatement)stmt).getQueryExpr()) != null && (withTables = qRoot.getWithClause()).size() > 0) {
                childList.addAll((Collection<TableCorrelation>)withTables);
            }
        }
        if (parentElement instanceof Schema) {
            childList = new ArrayList();
            Schema schema = (Schema)parentElement;
            childList.addAll((Collection<TableCorrelation>)schema.getTables());
        }
        Comparator comp = new Comparator(){
            Collator fCollator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                int result = 0;
                SQLObject so1 = (SQLObject)o1;
                SQLObject so2 = (SQLObject)o2;
                result = this.fCollator.compare(so1.getName(), so2.getName());
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        };
        Collections.sort(childList, comp);
        return childList.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof Schema) {
            hasChildren = true;
        } else if (element instanceof TableCorrelation) {
            hasChildren = true;
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public String getText(Object object) {
        String text = "";
        if (object instanceof Schema) {
            text = ((Schema)object).getName();
        } else if (object instanceof Table) {
            text = ((Table)object).getName();
        } else if (object instanceof WithTableSpecification) {
            text = ((WithTableSpecification)object).getName();
        } else if (object instanceof TableCorrelation) {
            text = ((TableCorrelation)object).getName();
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public Image getImage(Object object) {
        Image image = null;
        image = object instanceof Schema || object instanceof TableCorrelation ? SQLBuilderPlugin.getPlugin().getImage("icons/schema.gif") : (object instanceof BaseTable ? SQLBuilderPlugin.getPlugin().getImage("icons/tables_tab.gif") : (object instanceof DerivedTable || object instanceof WithTableSpecification ? SQLBuilderPlugin.getPlugin().getImage("icons/view.gif") : SQLBuilderPlugin.getPlugin().getImage("icons/alias.gif")));
        return image;
    }
}

