/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class ParameterInformation {
    @NonNull
    private Either<String, Tuple.Two<Integer, Integer>> label;
    private Either<String, MarkupContent> documentation;

    public ParameterInformation() {
    }

    public ParameterInformation(@NonNull String label) {
        this.setLabel(Preconditions.checkNotNull(label, "label"));
    }

    public ParameterInformation(@NonNull String label, String documentation) {
        this(label);
        this.setDocumentation(documentation);
    }

    public ParameterInformation(@NonNull String label, MarkupContent documentation) {
        this(label);
        this.setDocumentation(documentation);
    }

    @NonNull
    public Either<String, Tuple.Two<Integer, Integer>> getLabel() {
        return this.label;
    }

    public void setLabel(@NonNull Either<String, Tuple.Two<Integer, Integer>> label) {
        this.label = Preconditions.checkNotNull(label, "label");
    }

    public void setLabel(String label) {
        if (label == null) {
            Preconditions.checkNotNull(label, "label");
            this.label = null;
            return;
        }
        this.label = Either.forLeft(label);
    }

    public void setLabel(Tuple.Two<Integer, Integer> label) {
        if (label == null) {
            Preconditions.checkNotNull(label, "label");
            this.label = null;
            return;
        }
        this.label = Either.forRight(label);
    }

    public Either<String, MarkupContent> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Either<String, MarkupContent> documentation) {
        this.documentation = documentation;
    }

    public void setDocumentation(String documentation) {
        if (documentation == null) {
            this.documentation = null;
            return;
        }
        this.documentation = Either.forLeft(documentation);
    }

    public void setDocumentation(MarkupContent documentation) {
        if (documentation == null) {
            this.documentation = null;
            return;
        }
        this.documentation = Either.forRight(documentation);
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("label", this.label);
        b.add("documentation", this.documentation);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterInformation other = (ParameterInformation)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
    }
}

