/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocationHint;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;
import org.w3c.dom.NamedNodeMap;

public class ContentModelDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private final URIResolverExtensionManager resolverManager;

    public ContentModelDocumentLinkParticipant(URIResolverExtensionManager resolverManager) {
        this.resolverManager = resolverManager;
    }

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        SchemaLocation schemaLocation;
        DOMDocumentType docType = document.getDoctype();
        if (docType != null) {
            String location = this.resolverManager.resolve(document.getDocumentURI(), docType.getPublicIdWithoutQuotes(), docType.getSystemIdWithoutQuotes());
            if (location != null) {
                try {
                    DTDDeclParameter systemIdRange = docType.getSystemIdNode();
                    if (systemIdRange != null) {
                        links.add(XMLPositionUtility.createDocumentLink(systemIdRange, location, true));
                    }
                }
                catch (BadLocationException systemIdRange) {
                    // empty catch block
                }
            }
            NamedNodeMap entities = docType.getEntities();
            for (int i = 0; i < entities.getLength(); ++i) {
                DTDEntityDecl entity = (DTDEntityDecl)entities.item(i);
                location = this.resolverManager.resolve(document.getDocumentURI(), entity.getPublicId(), entity.getSystemId());
                if (location == null) continue;
                try {
                    DTDDeclParameter systemIdRange = entity.getSystemIdNode();
                    if (systemIdRange == null) continue;
                    links.add(XMLPositionUtility.createDocumentLink(systemIdRange, location, true));
                    continue;
                }
                catch (BadLocationException systemIdRange) {
                    // empty catch block
                }
            }
        }
        List<XMLModel> xmlModels = document.getXMLModels();
        for (XMLModel xmlModel : xmlModels) {
            String location = this.resolverManager.resolve(document.getDocumentURI(), null, xmlModel.getHref());
            if (location == null) continue;
            try {
                DOMRange hrefRange = xmlModel.getHrefNode();
                if (hrefRange == null) continue;
                links.add(XMLPositionUtility.createDocumentLink(hrefRange, location, true));
            }
            catch (BadLocationException hrefRange) {}
        }
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation != null) {
            try {
                DOMRange attrValue;
                String location = this.resolverManager.resolve(document.getDocumentURI(), null, noNamespaceSchemaLocation.getLocation());
                if (location != null && (attrValue = noNamespaceSchemaLocation.getAttr().getNodeAttrValue()) != null) {
                    links.add(XMLPositionUtility.createDocumentLink(attrValue, location, true));
                }
            }
            catch (BadLocationException location) {
                // empty catch block
            }
        }
        if ((schemaLocation = document.getSchemaLocation()) != null) {
            try {
                Collection<SchemaLocationHint> schemaLocationHints = schemaLocation.getSchemaLocationHints();
                for (SchemaLocationHint schemaLocationHint : schemaLocationHints) {
                    String location = this.resolverManager.resolve(document.getDocumentURI(), null, schemaLocationHint.getHint());
                    if (location == null) continue;
                    links.add(XMLPositionUtility.createDocumentLink(schemaLocationHint, location, false));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

