/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.model.CompleteEnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;

public final class EnterActionHelper {
    public static @Nullable CompleteEnterAction getEnterAction(IDocument doc, int offset, OnEnterSupport onEnterSupport) {
        EnterAction enterResult;
        block8: {
            int lineIndex = doc.getLineOfOffset(offset);
            int lineLength = doc.getLineLength(lineIndex);
            int lineStartOffset = doc.getLineOffset(lineIndex);
            String beforeEnterText = doc.get(lineStartOffset, offset - lineStartOffset);
            String afterEnterText = doc.get(offset, lineLength - (offset - lineStartOffset));
            String previousLineText = "";
            if (lineIndex > 0) {
                previousLineText = DocumentHelper.getLineText((IDocument)doc, (int)(lineIndex - 1), (boolean)false);
            }
            if ((enterResult = onEnterSupport.onEnter(previousLineText, beforeEnterText, afterEnterText)) != null) break block8;
            return null;
        }
        try {
            EnterAction.IndentAction indentAction = enterResult.indentAction;
            @Nullable Object appendText = enterResult.appendText;
            @Nullable Integer removeText = enterResult.removeText;
            if (appendText == null) {
                appendText = indentAction == EnterAction.IndentAction.Indent || indentAction == EnterAction.IndentAction.IndentOutdent ? "\t" : "";
            } else if (indentAction == EnterAction.IndentAction.Indent) {
                appendText = "\t" + (String)appendText;
            }
            String indentation = TextUtils.getIndentationAtPosition(doc, offset);
            if (removeText != null) {
                indentation = indentation.substring(0, indentation.length() - removeText);
            }
            return new CompleteEnterAction(indentAction, (String)appendText, removeText, indentation);
        }
        catch (RuntimeException | BadLocationException throwable) {
            return null;
        }
    }

    private EnterActionHelper() {
    }
}

