/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.AssociativeInfixExpressionFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.SimpleExpressionFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.SimpleFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.Util;

public class ASTFragmentFactory {
    public static IASTFragment createFragmentForFullSubtree(ASTNode node) {
        IASTFragment result = FragmentForFullSubtreeFactory.createFragmentFor(node);
        Assert.isNotNull((Object)result);
        return result;
    }

    public static IASTFragment createFragmentForSourceRange(ISourceRange range, ASTNode scope, ICompilationUnit cu) throws JavaModelException {
        SelectionAnalyzer sa = new SelectionAnalyzer(Selection.createFromStartLength(range.getOffset(), range.getLength()), false);
        scope.accept((ASTVisitor)sa);
        if (ASTFragmentFactory.isSingleNodeSelected(sa, range, cu)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getFirstSelectedNode());
        }
        if (ASTFragmentFactory.isEmptySelectionCoveredByANode(range, sa)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getLastCoveringNode());
        }
        return ASTFragmentFactory.createFragmentForSubPartBySourceRange(sa.getLastCoveringNode(), range, cu);
    }

    private static boolean isEmptySelectionCoveredByANode(ISourceRange range, SelectionAnalyzer sa) {
        return range.getLength() == 0 && sa.getFirstSelectedNode() == null && sa.getLastCoveringNode() != null;
    }

    private static boolean isSingleNodeSelected(SelectionAnalyzer sa, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
        return sa.getSelectedNodes().length == 1 && !ASTFragmentFactory.rangeIncludesNonWhitespaceOutsideNode(range, sa.getFirstSelectedNode(), cu);
    }

    private static boolean rangeIncludesNonWhitespaceOutsideNode(ISourceRange range, ASTNode node, ICompilationUnit cu) throws JavaModelException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, SourceRangeFactory.create(node), cu.getBuffer());
    }

    private static IASTFragment createFragmentForSubPartBySourceRange(ASTNode node, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
        return FragmentForSubPartBySourceRangeFactory.createFragmentFor(node, range, cu);
    }

    private ASTFragmentFactory() {
    }

    private static abstract class FragmentFactory
    extends HierarchicalASTVisitor {
        private IASTFragment fFragment;

        private FragmentFactory() {
        }

        protected IASTFragment createFragment(ASTNode node) {
            this.fFragment = null;
            node.accept((ASTVisitor)this);
            return this.fFragment;
        }

        protected final IASTFragment getFragment() {
            return this.fFragment;
        }

        protected final void setFragment(IASTFragment fragment) {
            Assert.isTrue((!this.isFragmentSet() ? 1 : 0) != 0);
            this.fFragment = fragment;
        }

        protected final boolean isFragmentSet() {
            return this.getFragment() != null;
        }
    }

    private static class FragmentForFullSubtreeFactory
    extends FragmentFactory {
        private FragmentForFullSubtreeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node) {
            return new FragmentForFullSubtreeFactory().createFragment(node);
        }

        @Override
        public boolean visit(InfixExpression node) {
            IExpressionFragment fragment = AssociativeInfixExpressionFragment.createFragmentForFullSubtree(node);
            if (fragment == null) {
                return this.visit((Expression)node);
            }
            this.setFragment(fragment);
            return false;
        }

        @Override
        public boolean visit(Expression node) {
            this.setFragment(new SimpleExpressionFragment(node));
            return false;
        }

        @Override
        public boolean visit(ASTNode node) {
            this.setFragment(new SimpleFragment(node));
            return false;
        }
    }

    private static class FragmentForSubPartBySourceRangeFactory
    extends FragmentFactory {
        private ISourceRange fRange;
        private ICompilationUnit fCu;
        private JavaModelException javaModelException = null;

        private FragmentForSubPartBySourceRangeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
            return new FragmentForSubPartBySourceRangeFactory().createFragment(node, range, cu);
        }

        @Override
        public boolean visit(InfixExpression node) {
            try {
                this.setFragment(FragmentForSubPartBySourceRangeFactory.createInfixExpressionSubPartFragmentBySourceRange(node, this.fRange, this.fCu));
            }
            catch (JavaModelException e) {
                this.javaModelException = e;
            }
            return false;
        }

        @Override
        public boolean visit(ASTNode node) {
            return false;
        }

        protected IASTFragment createFragment(ASTNode node, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
            this.fRange = range;
            this.fCu = cu;
            IASTFragment result = this.createFragment(node);
            if (this.javaModelException != null) {
                throw this.javaModelException;
            }
            return result;
        }

        private static IExpressionFragment createInfixExpressionSubPartFragmentBySourceRange(InfixExpression node, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
            return AssociativeInfixExpressionFragment.createSubPartFragmentBySourceRange(node, range, cu);
        }
    }
}

