/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleWiring;

public class Caller {
    private static final VersionRange JUNIT5_VERSION_RANGE = new VersionRange("[1.0.0,6.0.0)");
    private static final VersionRange JUNIT6_VERSION_RANGE = new VersionRange("[6.0.0,7.0.0)");
    private static final String JUNIT_PLATFORM_LAUNCHER = "org.junit.platform.launcher";
    private static final Bundle BUNDLE = FrameworkUtil.getBundle(Caller.class);
    private static final Bundle LOADER_BUNDLE_JUNIT_5 = Caller.findJUnitBundle("org.eclipse.jdt.junit5.runtime", JUNIT5_VERSION_RANGE);
    private static final Bundle LOADER_BUNDLE_JUNIT_6 = Caller.findJUnitBundle("org.eclipse.jdt.junit6.runtime", JUNIT6_VERSION_RANGE);

    private static Bundle findJUnitBundle(String bundleId, VersionRange versionRange) {
        Bundle junitRuntimeBundle = Platform.getBundle((String)bundleId);
        if (junitRuntimeBundle == null) {
            Bundle junit4RuntimeBundle = Platform.getBundle((String)"org.eclipse.jdt.junit4.runtime");
            return Caller.findJUnitLauncherByRuntime(junit4RuntimeBundle, versionRange);
        }
        return junitRuntimeBundle;
    }

    protected static Bundle findJUnitLauncherByRuntime(Bundle junit4RuntimeBundle, VersionRange junitPlatformVersionRange) {
        if (junit4RuntimeBundle == null) {
            return BUNDLE;
        }
        Bundle[] bundleArray = BUNDLE.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List capabilities = bundleWiring.getCapabilities(JUNIT_PLATFORM_LAUNCHER);
            if (!capabilities.isEmpty() && junitPlatformVersionRange.includes(bundle.getVersion())) {
                return bundle;
            }
            ++n2;
        }
        return BUNDLE;
    }

    static Bundle getBundle(int junitVersion) {
        StackTraceElement[] stackTraceElements;
        StackTraceElement[] stackTraceElementArray = stackTraceElements = Thread.currentThread().getStackTrace();
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            try {
                Bundle loaderBundle;
                String className = element.getClassName();
                if (junitVersion == 5) {
                    loaderBundle = LOADER_BUNDLE_JUNIT_5;
                } else if (junitVersion == 6) {
                    loaderBundle = LOADER_BUNDLE_JUNIT_6;
                } else {
                    throw new IllegalArgumentException("Unsupported junit version: " + junitVersion);
                }
                Class clz = loaderBundle.loadClass(className);
                Bundle bundle = FrameworkUtil.getBundle((Class)clz);
                if (bundle != BUNDLE && bundle != null) {
                    return bundle;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }
}

