/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class MemoizedScopeCreator
implements ScopeCreator,
StaticSymbolTable<TypedVar, TypedVar> {
    private final Map<Node, TypedScope> scopes = new LinkedHashMap<Node, TypedScope>();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterable<TypedVar> getReferences(TypedVar var) {
        return ImmutableList.of((Object)var);
    }

    public TypedScope getScope(TypedVar var) {
        return var.scope;
    }

    @Override
    public Iterable<TypedVar> getAllSymbols() {
        ArrayList<TypedVar> vars = new ArrayList<TypedVar>();
        for (TypedScope s : this.scopes.values()) {
            Iterables.addAll(vars, s.getAllSymbols());
        }
        return vars;
    }

    public TypedScope createScope(Node n, Scope parent) {
        Preconditions.checkArgument((parent == null || parent instanceof TypedScope ? 1 : 0) != 0);
        TypedScope typedParent = (TypedScope)parent;
        TypedScope scope = this.scopes.get(n);
        if (scope == null) {
            scope = this.delegate.createScope(n, typedParent);
            this.scopes.put(n, scope);
        } else {
            Preconditions.checkState((typedParent == scope.getParent() ? 1 : 0) != 0);
        }
        return scope;
    }

    Collection<TypedScope> getAllMemoizedScopes() {
        ArrayList<TypedScope> temp = new ArrayList<TypedScope>(this.scopes.values());
        Collections.reverse(temp);
        return Collections.unmodifiableCollection(temp);
    }

    void removeScopesForScript(String scriptName) {
        for (Node scopeRoot : ImmutableSet.copyOf(this.scopes.keySet())) {
            if (!scriptName.equals(scopeRoot.getSourceFileName())) continue;
            this.scopes.remove(scopeRoot);
        }
    }

    @Override
    public boolean hasBlockScope() {
        return this.delegate.hasBlockScope();
    }
}

