/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class EnumeratedTypeSet
extends TypeSet {
    private static int sCount = 0;
    Set<TType> fMembers = new LinkedHashSet<TType>();
    private static final int sMaxElements = 10;

    public static int getCount() {
        return sCount;
    }

    public static void resetCount() {
        sCount = 0;
    }

    public EnumeratedTypeSet(Iterator<TType> types, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        while (types.hasNext()) {
            this.fMembers.add(types.next());
        }
        ++sCount;
    }

    public EnumeratedTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        ++sCount;
    }

    public EnumeratedTypeSet(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)t);
        this.fMembers.add(t);
        ++sCount;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet other = (EnumeratedTypeSet)o;
            return this.fMembers.equals(other.fMembers);
        }
        if (o instanceof SingletonTypeSet) {
            SingletonTypeSet other = (SingletonTypeSet)o;
            return this.fMembers.size() == 1 && this.fMembers.contains(other.anyMember());
        }
        if (o instanceof TypeSet) {
            TypeSet other = (TypeSet)o;
            Iterator<TType> otherIter = other.iterator();
            while (otherIter.hasNext()) {
                if (this.fMembers.contains(otherIter.next())) continue;
                return false;
            }
            for (TType tType : this.fMembers) {
                if (other.contains(tType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 37 + this.fMembers.hashCode();
    }

    @Override
    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2 instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            result.addAll(this);
            result.retainAll(s2);
            if (result.size() > 0) {
                return result;
            }
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        return null;
    }

    public void intersectWith(TypeSet s2) {
        if (this.isUniverse()) {
            if (s2.isUniverse()) {
                return;
            }
            EnumeratedTypeSet ets2 = (EnumeratedTypeSet)s2;
            this.fMembers = new LinkedHashSet<TType>();
            this.fMembers.addAll(ets2.fMembers);
        } else {
            this.retainAll(s2);
        }
    }

    @Override
    public TypeSet subTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    public static EnumeratedTypeSet makeArrayTypesForElements(Iterator<TType> elemTypes, TypeSetEnvironment typeSetEnvironment) {
        EnumeratedTypeSet result = new EnumeratedTypeSet(typeSetEnvironment);
        while (elemTypes.hasNext()) {
            TType t = elemTypes.next();
            result.add(TTypes.createArrayType(t, 1));
        }
        return result;
    }

    @Override
    public TypeSet superTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    @Override
    public TypeSet makeClone() {
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        result.initComplete();
        return result;
    }

    public int size() {
        return this.fMembers.size();
    }

    public void clear() {
        if (this.isUniverse()) {
            this.fMembers = new LinkedHashSet<TType>();
        } else {
            this.fMembers.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fMembers.isEmpty();
    }

    public TType[] toArray() {
        return this.fMembers.toArray(new TType[this.fMembers.size()]);
    }

    public boolean add(TType t) {
        Assert.isTrue((!this.isUniverse() ? 1 : 0) != 0, (String)"Someone's trying to expand the universe!");
        return this.fMembers.add(t);
    }

    @Override
    public boolean contains(TType t) {
        if (this.isUniverse()) {
            return true;
        }
        return this.fMembers.contains(t);
    }

    public boolean remove(TType t) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.remove(t);
    }

    private Set<TType> cloneSet(Set<TType> members) {
        return new LinkedHashSet<TType>(members);
    }

    public boolean addAll(TypeSet s) {
        if (s instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet ets = (EnumeratedTypeSet)s;
            return this.fMembers.addAll(ets.fMembers);
        }
        EnumeratedTypeSet ets = s.enumerate();
        return this.fMembers.addAll(ets.fMembers);
    }

    @Override
    public TypeSet addedTo(TypeSet that) {
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.addAll(this);
        result.addAll(that);
        result.initComplete();
        return result;
    }

    @Override
    public boolean containsAll(TypeSet s) {
        if (this.isUniverse()) {
            return true;
        }
        if (s.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet ets = s.enumerate();
        return this.fMembers.containsAll(ets.fMembers);
    }

    public boolean removeAll(EnumeratedTypeSet s) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.removeAll(s.fMembers);
    }

    public boolean retainAll(TypeSet s) {
        if (s.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet ets = (EnumeratedTypeSet)s;
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(ets.fMembers);
            return true;
        }
        return this.fMembers.retainAll(ets.fMembers);
    }

    @Override
    public boolean isSingleton() {
        return this.fMembers.size() == 1;
    }

    @Override
    public TType anyMember() {
        return this.fMembers.iterator().next();
    }

    @Override
    public TypeSet upperBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet(this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        for (TType t : this.fMembers) {
            if (t.isArrayType()) {
                ArrayType at = (ArrayType)t;
                int numDims = at.getDimensions();
                Iterator<TType> subIter = TTypes.getAllSubTypesIterator(at.getElementType());
                while (subIter.hasNext()) {
                    result.fMembers.remove(TTypes.createArrayType(subIter.next(), numDims));
                }
                continue;
            }
            Iterator<TType> iterator = TTypes.getAllSubTypesIterator(t);
            while (iterator.hasNext()) {
                result.fMembers.remove(iterator.next());
            }
        }
        result.initComplete();
        return result;
    }

    @Override
    public TypeSet lowerBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet(this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet result = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        result.fMembers.addAll(this.fMembers);
        for (TType t : this.fMembers) {
            if (t.equals(this.getJavaLangObject())) {
                result.fMembers.remove(t);
                continue;
            }
            if (t instanceof ArrayType) {
                ArrayType at = (ArrayType)t;
                int numDims = at.getDimensions();
                Iterator<TType> superIter = TTypes.getAllSuperTypesIterator(at.getElementType());
                while (superIter.hasNext()) {
                    result.fMembers.remove(TTypes.createArrayType(superIter.next(), numDims));
                }
                continue;
            }
            Iterator<TType> iterator = TTypes.getAllSuperTypesIterator(t);
            while (iterator.hasNext()) {
                result.fMembers.remove(iterator.next());
            }
        }
        if (result.size() > 0) {
            return result;
        }
        return this.getTypeSetEnvironment().getEmptyTypeSet();
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return this.fMembers.size() == 1;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return this.fMembers.size() == 1;
    }

    @Override
    public TType uniqueLowerBound() {
        if (this.fMembers.size() == 1) {
            return this.fMembers.iterator().next();
        }
        return null;
    }

    @Override
    public TType uniqueUpperBound() {
        if (this.fMembers.size() == 1) {
            return this.fMembers.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<TType> iterator() {
        return this.fMembers.iterator();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{" + this.fID + ":");
        if (this.isUniverse()) {
            b.append(" <universe>");
        } else {
            int count = 0;
            Iterator<TType> iter = this.iterator();
            while (iter.hasNext() && count < 10) {
                TType type = iter.next();
                b.append(' ').append(type.getPrettySignature());
                if (iter.hasNext()) {
                    b.append(',');
                }
                ++count;
            }
            if (iter.hasNext()) {
                b.append(" ...");
            }
        }
        b.append(" }");
        return b.toString();
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        return this;
    }

    public void initComplete() {
        Assert.isTrue((!this.fMembers.isEmpty() ? 1 : 0) != 0);
    }
}

