/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Connection;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;

public class BasicRel
implements Rel {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String fName;
    private Element fSourceElement;
    private Vector fConnections;

    public BasicRel(String name, Element sourceElement) {
        this.fName = name;
        this.fSourceElement = sourceElement;
        this.fConnections = new Vector();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Element getSourceElement() {
        return this.fSourceElement;
    }

    @Override
    public Enumeration getTargetElements() {
        return new ElementEnumeration(this.fConnections.elements());
    }

    @Override
    public int getNumberOfTargetElements() {
        return this.fConnections.size();
    }

    @Override
    public void addConnection(Connection connection) {
        this.fConnections.addElement(connection);
    }

    @Override
    public boolean removeConnection(Connection connection) {
        return this.fConnections.removeElement(connection);
    }

    @Override
    public Connection getConnectionTo(Element targetElement) {
        Enumeration e = this.fConnections.elements();
        while (e.hasMoreElements()) {
            Connection c = (Connection)e.nextElement();
            if (c.getElement() != targetElement) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private class ElementEnumeration
    implements Enumeration {
        private Enumeration fConnectionEnumeration;

        public ElementEnumeration(Enumeration connectionEnumeration) {
            this.fConnectionEnumeration = connectionEnumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.fConnectionEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ((Connection)this.fConnectionEnumeration.nextElement()).getElement();
        }
    }
}

