/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.ObjectFilterTest;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ObjectActionContributor
extends PluginActionBuilder
implements IObjectActionContributor,
IAdaptable {
    private static final String P_TRUE = "true";
    private final IConfigurationElement config;
    private boolean configRead = false;
    private boolean adaptable = false;
    private final String objectClass;

    public ObjectActionContributor(IConfigurationElement config) {
        this.config = config;
        this.adaptable = P_TRUE.equalsIgnoreCase(config.getAttribute("adaptable"));
        this.objectClass = config.getAttribute("objectClass");
    }

    @Override
    public boolean canAdapt() {
        return this.adaptable;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    @Override
    public void contributeObjectActionIdOverrides(List actionIdOverrides) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions != null) {
            for (ActionDescriptor ad : this.currentContribution.actions) {
                String id = ad.getAction().getOverrideActionId();
                if (id == null) continue;
                actionIdOverrides.add(id);
            }
        }
    }

    @Override
    public boolean contributeObjectActions(final IWorkbenchPart part, IMenuManager menu, ISelectionProvider selProv, List actionIdOverrides) {
        IStructuredSelection ssel;
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)sel;
        if (this.canAdapt()) {
            IStructuredSelection newSelection = LegacyResourceSupport.adaptSelection(ssel, this.getObjectClass());
            if (newSelection.size() != ssel.size()) {
                if (Policy.DEBUG_CONTRIBUTIONS) {
                    WorkbenchPlugin.log("Error adapting selection to " + this.getObjectClass() + ". Contribution " + this.getID(this.config) + " is being ignored");
                }
                return false;
            }
            ssel = newSelection;
        }
        void selection = ssel;
        for (ActionDescriptor ad : this.currentContribution.actions) {
            if (actionIdOverrides.contains(ad.getId())) continue;
            this.currentContribution.contributeMenuAction(ad, menu, true);
            if (!(ad.getAction() instanceof ObjectPluginAction)) continue;
            final ObjectPluginAction action = (ObjectPluginAction)ad.getAction();
            ISafeRunnable runnable = new ISafeRunnable((IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                }

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log("Failed to update action " + action.getId(), exception);
                }

                public void run() throws Exception {
                    action.setActivePart(part);
                    action.selectionChanged((ISelection)this.val$selection);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        return true;
    }

    @Override
    public boolean contributeObjectMenus(IMenuManager menu, ISelectionProvider selProv) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.menus == null) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        for (IConfigurationElement menuElement : this.currentContribution.menus) {
            this.currentContribution.contributeMenu(menuElement, menu, true);
        }
        return true;
    }

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 1);
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ObjectContribution();
    }

    @Override
    public boolean isApplicableTo(Object object) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.canAdapt()) {
            Object adapted = LegacyResourceSupport.getAdapter(object, this.getObjectClass());
            if (adapted == null) {
                if (Policy.DEBUG_CONTRIBUTIONS) {
                    WorkbenchPlugin.log("Error adapting " + object.getClass().getName() + " to " + this.getObjectClass() + ". Contribution " + this.getID(this.config) + " is being ignored");
                }
            } else {
                object = adapted;
            }
        }
        if (!this.testName(object)) {
            return false;
        }
        return ((ObjectContribution)this.currentContribution).isApplicableTo(object);
    }

    private void readConfigElement() {
        this.currentContribution = this.createContribution();
        this.readElementChildren(this.config);
        this.configRead = true;
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("visibility")) {
            ((ObjectContribution)this.currentContribution).setVisibilityTest(element);
            return true;
        }
        if (tag.equals("filter")) {
            ((ObjectContribution)this.currentContribution).addFilterTest(element);
            return true;
        }
        if (tag.equals("enablement")) {
            ((ObjectContribution)this.currentContribution).setEnablementTest(element);
            return true;
        }
        return super.readElement(element);
    }

    private boolean testName(Object object) {
        String nameFilter = this.config.getAttribute("nameFilter");
        if (nameFilter == null) {
            return true;
        }
        String objectName = null;
        IWorkbenchAdapter de = (IWorkbenchAdapter)Adapters.adapt((Object)object, IWorkbenchAdapter.class);
        if (de != null) {
            objectName = de.getLabel(object);
        }
        if (objectName == null) {
            objectName = object.toString();
        }
        return SelectionEnabler.verifyNameMatch(objectName, nameFilter);
    }

    public String toString() {
        IConfigurationElement[] children;
        StringBuilder buffer = new StringBuilder();
        IConfigurationElement[] iConfigurationElementArray = children = this.config.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String label = element.getAttribute("label");
            if (label != null) {
                buffer.append(label);
                buffer.append('\n');
            }
            ++n2;
        }
        return buffer.toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IConfigurationElement.class)) {
            return adapter.cast(this.config);
        }
        return null;
    }

    private static class ObjectContribution
    extends PluginActionBuilder.BasicContribution {
        private ObjectFilterTest filterTest;
        private ActionExpression visibilityTest;
        private Expression enablement;

        private ObjectContribution() {
        }

        public void addFilterTest(IConfigurationElement element) {
            if (this.filterTest == null) {
                this.filterTest = new ObjectFilterTest();
            }
            this.filterTest.addFilterElement(element);
        }

        public void setVisibilityTest(IConfigurationElement element) {
            this.visibilityTest = new ActionExpression(element);
        }

        public void setEnablementTest(IConfigurationElement element) {
            try {
                this.enablement = ExpressionConverter.getDefault().perform(element);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log(e);
            }
        }

        public boolean isApplicableTo(Object object) {
            boolean result = true;
            if (this.visibilityTest != null) {
                boolean bl = result = result && this.visibilityTest.isEnabledFor(object);
                if (!result) {
                    return result;
                }
            } else if (this.filterTest != null) {
                boolean bl = result = result && this.filterTest.matches(object);
                if (!result) {
                    return result;
                }
            }
            if (this.enablement != null) {
                try {
                    EvaluationContext context = new EvaluationContext(null, object);
                    context.setAllowPluginActivation(true);
                    context.addVariable("selection", object);
                    context.addVariable("org.eclipse.core.runtime.Platform", Platform.class);
                    EvaluationResult evalResult = this.enablement.evaluate((IEvaluationContext)context);
                    if (evalResult == EvaluationResult.FALSE) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    this.enablement = null;
                    WorkbenchPlugin.log(e);
                    result = false;
                }
            }
            return result;
        }
    }
}

