/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;

public class BasicContext
implements IContext,
ISourceModuleContext {
    private final ISourceModule sourceModule;
    private final ModuleDeclaration rootNode;

    public BasicContext(ISourceModule sourceModule, ModuleDeclaration rootNode) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
    }

    public BasicContext(ISourceModuleContext parent) {
        this.sourceModule = parent.getSourceModule();
        this.rootNode = parent.getRootNode();
    }

    @Override
    public ModuleDeclaration getRootNode() {
        return this.rootNode;
    }

    @Override
    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public String getLangNature() {
        IDLTKLanguageToolkit languageToolkit;
        if (this.sourceModule != null && (languageToolkit = DLTKLanguageManager.getLanguageToolkit(this.sourceModule)) != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public String toString() {
        return "BasicContext, module " + this.sourceModule.getElementName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sourceModule == null ? 0 : this.sourceModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicContext other = (BasicContext)obj;
        return !(this.sourceModule == null ? other.sourceModule != null : !this.sourceModule.equals(other.sourceModule));
    }
}

