/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Serializable;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;

public abstract class StaticScope
implements Serializable {
    private static final long serialVersionUID = 4843861446986961013L;
    private StaticScope enclosingScope;
    private String[] variableNames;

    protected StaticScope(StaticScope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public int addVariable(String name) {
        int slot = this.isDefined(name);
        if (slot >= 0) {
            return slot;
        }
        if (this.variableNames == null) {
            this.variableNames = new String[1];
            this.variableNames[0] = name;
        } else {
            String[] newVariableNames = new String[this.variableNames.length + 1];
            System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
            this.variableNames = newVariableNames;
            this.variableNames[this.variableNames.length - 1] = name;
        }
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames == null ? 0 : this.variableNames.length;
    }

    public void setVariables(String[] names) {
        if (names == null) {
            return;
        }
        this.variableNames = new String[names.length];
        System.arraycopy(names, 0, this.variableNames, 0, names.length);
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name) {
        if (this.variableNames != null) {
            int i = 0;
            while (i < this.variableNames.length) {
                if (name == this.variableNames[i] || name.equals(this.variableNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int isDefined(String name) {
        return this.isDefined(name, 0);
    }

    public AssignableNode assign(ISourcePosition position, String name, Node value) {
        return this.assign(position, name, value, this, 0);
    }

    public abstract String[] getAllNamesInScope();

    protected abstract int isDefined(String var1, int var2);

    protected abstract AssignableNode assign(ISourcePosition var1, String var2, Node var3, StaticScope var4, int var5);

    protected abstract Node declare(ISourcePosition var1, String var2, int var3);

    public Node declare(ISourcePosition position, String name) {
        return this.declare(position, name, 0);
    }

    public abstract StaticScope getLocalScope();
}

