/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.compiler.CharOperation;

public class CharOperationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CharOperationTests.class);
    }

    public void testSplitOnNull() {
        char[][] result = CharOperation.splitOn((char[])"::".toCharArray(), null);
        CharOperationTests.assertNull((Object)result);
    }

    public void testSplitOn1() {
        char[][] result = CharOperation.splitOn((char[])"::".toCharArray(), (char[])"AAA".toCharArray());
        CharOperationTests.assertEquals((int)1, (int)result.length);
        CharOperationTests.assertEquals((String)"AAA", (String)new String(result[0]));
    }

    public void testSplitOn2() {
        char[][] result = CharOperation.splitOn((char[])"::".toCharArray(), (char[])"A::B".toCharArray());
        CharOperationTests.assertEquals((int)2, (int)result.length);
        CharOperationTests.assertEquals((String)"A", (String)new String(result[0]));
        CharOperationTests.assertEquals((String)"B", (String)new String(result[1]));
    }

    public void testSplitOn3() {
        char[][] result = CharOperation.splitOn((char[])"::".toCharArray(), (char[])"AA::BB::CC".toCharArray());
        CharOperationTests.assertEquals((int)3, (int)result.length);
        CharOperationTests.assertEquals((String)"AA", (String)new String(result[0]));
        CharOperationTests.assertEquals((String)"BB", (String)new String(result[1]));
        CharOperationTests.assertEquals((String)"CC", (String)new String(result[2]));
    }

    public void testStringConcatWith() {
        char[] result = CharOperation.concatWith((String[])new String[]{"A", "B"}, (char)'.');
        CharOperationTests.assertEquals((int)3, (int)result.length);
        CharOperationTests.assertEquals((char)'A', (char)result[0]);
        CharOperationTests.assertEquals((char)'.', (char)result[1]);
        CharOperationTests.assertEquals((char)'B', (char)result[2]);
    }
}

