/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.ddp;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ti.DefaultTypeInferencer;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class CoreDDPTests
extends SuiteOfTestCases {
    public CoreDDPTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new SuiteOfTestCases.Suite(CoreDDPTests.class);
    }

    public void testSimple() throws Exception {
        SimpleReference x = new SimpleReference(0, 0, "x");
        SimpleReference y = new SimpleReference(0, 0, "y");
        NumericLiteral num = new NumericLiteral(0, 0, 0L);
        IGoalEvaluatorFactory factory = new IGoalEvaluatorFactory((Expression)x, (Expression)y, (Expression)num){
            private final /* synthetic */ Expression val$x;
            private final /* synthetic */ Expression val$y;
            private final /* synthetic */ Expression val$num;
            {
                this.val$x = expression;
                this.val$y = expression2;
                this.val$num = expression3;
            }

            public GoalEvaluator createEvaluator(IGoal goal) {
                if (goal instanceof ExpressionTypeGoal) {
                    ExpressionTypeGoal egoal = (ExpressionTypeGoal)goal;
                    ASTNode expr = egoal.getExpression();
                    if (expr == this.val$x) {
                        return new SingleDependentGoalEvaluator(goal, (IGoal)new ExpressionTypeGoal(null, (ASTNode)this.val$y), new MyNum());
                    }
                    if (expr == this.val$y) {
                        return new SingleDependentGoalEvaluator(goal, (IGoal)new ExpressionTypeGoal(null, (ASTNode)this.val$num), new MyNum());
                    }
                    if (expr == this.val$num) {
                        return new FixedAnswerGoalEvaluator(goal, new MyNum());
                    }
                }
                return null;
            }
        };
        DefaultTypeInferencer man = new DefaultTypeInferencer(factory);
        ExpressionTypeGoal rootGoal = new ExpressionTypeGoal(null, (ASTNode)x);
        IEvaluatedType answer = man.evaluateType((AbstractTypeGoal)rootGoal, -1);
        CoreDDPTests.assertTrue((boolean)(answer instanceof MyNum));
    }

    public void testCycles() throws Exception {
        SimpleReference x = new SimpleReference(0, 0, "x");
        SimpleReference y = new SimpleReference(0, 0, "y");
        SimpleReference z = new SimpleReference(0, 0, "z");
        NumericLiteral num = new NumericLiteral(0, 0, 0L);
        ArrayList evaluators = new ArrayList();
        IGoalEvaluatorFactory factory = new IGoalEvaluatorFactory((Expression)x, (Expression)y, (Expression)z, (Expression)num, evaluators){
            private final /* synthetic */ Expression val$x;
            private final /* synthetic */ Expression val$y;
            private final /* synthetic */ Expression val$z;
            private final /* synthetic */ Expression val$num;
            private final /* synthetic */ Collection val$evaluators;
            {
                this.val$x = expression;
                this.val$y = expression2;
                this.val$z = expression3;
                this.val$num = expression4;
                this.val$evaluators = collection;
            }

            public GoalEvaluator createEvaluator2(IGoal goal) {
                if (goal instanceof ExpressionTypeGoal) {
                    ExpressionTypeGoal egoal = (ExpressionTypeGoal)goal;
                    ASTNode expr = egoal.getExpression();
                    if (expr == this.val$x) {
                        return new SingleDependentGoalEvaluator(goal, new IGoal[]{new ExpressionTypeGoal(null, (ASTNode)this.val$y), new ExpressionTypeGoal(null, (ASTNode)this.val$z)}, (Object)new MyNum());
                    }
                    if (expr == this.val$y) {
                        return new SingleDependentGoalEvaluator(goal, new IGoal[]{new ExpressionTypeGoal(null, (ASTNode)this.val$z)}, (Object)new MyNum());
                    }
                    if (expr == this.val$z) {
                        return new SingleDependentGoalEvaluator(goal, new IGoal[]{new ExpressionTypeGoal(null, (ASTNode)this.val$num), new ExpressionTypeGoal(null, (ASTNode)this.val$y)}, (Object)new MyNum());
                    }
                    if (expr == this.val$num) {
                        return new FixedAnswerGoalEvaluator(goal, new MyNum());
                    }
                }
                return null;
            }

            public GoalEvaluator createEvaluator(IGoal goal) {
                GoalEvaluator result = this.createEvaluator2(goal);
                if (result != null) {
                    this.val$evaluators.add(result);
                }
                return result;
            }
        };
        DefaultTypeInferencer man = new DefaultTypeInferencer(factory);
        ExpressionTypeGoal rootGoal = new ExpressionTypeGoal(null, (ASTNode)x);
        IEvaluatedType answer = man.evaluateType((AbstractTypeGoal)rootGoal, -1);
        CoreDDPTests.assertTrue((boolean)(answer instanceof MyNum));
        for (GoalEvaluator ev : evaluators) {
            if (!(ev instanceof SingleDependentGoalEvaluator)) continue;
            SingleDependentGoalEvaluator sdge = (SingleDependentGoalEvaluator)ev;
            sdge.assertState();
        }
    }

    private static final class FixedAnswerGoalEvaluator
    extends GoalEvaluator {
        private final IEvaluatedType answer;

        private FixedAnswerGoalEvaluator(IGoal goal, IEvaluatedType answer) {
            super(goal);
            this.answer = answer;
        }

        public Object produceResult() {
            return this.answer;
        }

        public IGoal[] init() {
            return IGoal.NO_GOALS;
        }

        public IGoal[] subGoalDone(IGoal goal2, Object result, GoalState state) {
            return IGoal.NO_GOALS;
        }
    }

    class MyNum
    implements IEvaluatedType {
        MyNum() {
        }

        public String toString() {
            return "MyNum";
        }

        public String getTypeName() {
            return "MyNum";
        }

        public boolean subtypeOf(IEvaluatedType type) {
            return false;
        }
    }

    private static final class SingleDependentGoalEvaluator
    extends GoalEvaluator {
        private final IEvaluatedType answer;
        private final IGoal[] dependents;
        private int produceCalls = 0;
        private int produceTypeCalls = 0;

        private SingleDependentGoalEvaluator(IGoal goal, IGoal dependent, IEvaluatedType answer) {
            super(goal);
            this.dependents = new IGoal[]{dependent};
            this.answer = answer;
        }

        private SingleDependentGoalEvaluator(IGoal goal, IGoal[] dependents, Object answer) {
            super(goal);
            this.dependents = dependents;
            this.answer = (IEvaluatedType)answer;
        }

        public IGoal[] init() {
            ++this.produceCalls;
            return this.dependents;
        }

        public IGoal[] subGoalDone(IGoal goal2, Object result, GoalState _state) {
            ++this.produceCalls;
            CoreDDPTests.assertTrue((result instanceof MyNum || _state == GoalState.RECURSIVE ? 1 : 0) != 0);
            return IGoal.NO_GOALS;
        }

        public Object produceResult() {
            ++this.produceTypeCalls;
            return this.answer;
        }

        public void assertState() {
            CoreDDPTests.assertEquals((int)1, (int)this.produceTypeCalls);
            CoreDDPTests.assertEquals((int)(1 + this.dependents.length), (int)this.produceCalls);
        }

        public int getProduceCalls() {
            return this.produceCalls;
        }
    }
}

