/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.CompletionProposalCategory;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComputerRegistry;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;

public abstract class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.dltk.ui/debug/ResultCollector"));
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private final List fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CompletionProposalCategory d1 = (CompletionProposalCategory)o1;
            CompletionProposalCategory d2 = (CompletionProposalCategory)o2;
            return d1.getSortOrder() - d2.getSortOrder();
        }
    };
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;
    static /* synthetic */ Class class$0;

    public ContentAssistProcessor(ContentAssistant assistant, String partition) {
        Assert.isNotNull((Object)partition);
        Assert.isNotNull((Object)assistant);
        this.fPartition = partition;
        this.fCategories = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
                KeySequence binding = ContentAssistProcessor.this.getIterationBinding();
                ContentAssistProcessor.this.fCategoryIteration = ContentAssistProcessor.this.getCategoryIteration();
                Iterator it = ContentAssistProcessor.this.fCategories.iterator();
                while (it.hasNext()) {
                    CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
                    cat.sessionStarted();
                }
                ContentAssistProcessor.this.fRepetition = 0;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    if (ContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                        extension.setRepeatedInvocationMode(false);
                        extension.setShowEmptyList(false);
                    } else {
                        extension.setRepeatedInvocationMode(true);
                        extension.setStatusLineVisible(true);
                        extension.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                        extension.setShowEmptyList(true);
                        if (extension instanceof IContentAssistantExtension3) {
                            IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                            ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                        }
                    }
                }
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                Iterator it = ContentAssistProcessor.this.fCategories.iterator();
                while (it.hasNext()) {
                    CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
                    cat.sessionEnded();
                }
                ContentAssistProcessor.this.fCategoryIteration = null;
                ContentAssistProcessor.this.fRepetition = -1;
                ContentAssistProcessor.this.fIterationGesture = null;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    extension.setShowEmptyList(false);
                    extension.setRepeatedInvocationMode(false);
                    extension.setStatusLineVisible(false);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(KeySequence.getInstance());
                    }
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        long startTime = System.currentTimeMillis();
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(ScriptTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        long setupTime = System.currentTimeMillis();
        monitor.subTask(ScriptTextMessages.ContentAssistProcessor_collecting_proposals);
        List proposals = this.collectProposals(viewer, offset, monitor, context);
        long collectTime = System.currentTimeMillis();
        monitor.subTask(ScriptTextMessages.ContentAssistProcessor_sorting_proposals);
        List filtered = this.filterAndSortProposals(proposals, monitor, context);
        this.fNumberOfComputedResults = filtered.size();
        long filterTime = System.currentTimeMillis();
        ICompletionProposal[] result = filtered.toArray(new ICompletionProposal[filtered.size()]);
        monitor.done();
        if (DEBUG) {
            System.err.println("Code Assist stats of " + result.length + " proposals:");
            System.err.println("Code Assist (setup):\t" + (setupTime - startTime));
            System.err.println("Code Assist (collect):\t" + (collectTime - setupTime));
            System.err.println("Code Assist (sort):\t" + (filterTime - collectTime));
        }
        return result;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ArrayList proposals = new ArrayList();
        List providers = this.getCategories();
        Iterator it = providers.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            List computed = cat.computeCompletionProposals(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(ScriptTextMessages.ContentAssistProcessor_computing_contexts, this.fCategories.size() + 1);
        monitor.subTask(ScriptTextMessages.ContentAssistProcessor_collecting_contexts);
        List proposals = this.collectContextInformation(viewer, offset, monitor);
        monitor.subTask(ScriptTextMessages.ContentAssistProcessor_sorting_contexts);
        List filtered = this.filterAndSortContextInformation(proposals, monitor);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    private List collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ArrayList proposals = new ArrayList();
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        this.setContextInformationMode(context);
        List providers = this.getCategories();
        Iterator it = providers.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            List computed = cat.computeContextInformation(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortContextInformation(List contexts, IProgressMonitor monitor) {
        return contexts;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fCompletionAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        return DLTKUIMessages.ScriptEditor_codeassist_noCompletions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected void setContextInformationMode(ContentAssistInvocationContext context) {
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ContentAssistInvocationContext(viewer, offset);
    }

    private List getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int iteration = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return (List)this.fCategoryIteration.get(iteration);
    }

    private List getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> sequence = new ArrayList<List<CompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        Iterator it = this.getSeparateCategories().iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List getDefaultCategories() {
        List included = this.getDefaultCategoriesUnchecked();
        if ("__dftl_partition_content_type".equals(this.fPartition) && included.isEmpty() && !this.fCategories.isEmpty() && this.informUserAboutEmptyDefaultCategory()) {
            included = this.getDefaultCategoriesUnchecked();
        }
        return included;
    }

    private List getDefaultCategoriesUnchecked() {
        ArrayList<CompletionProposalCategory> included = new ArrayList<CompletionProposalCategory>();
        Iterator it = this.fCategories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory category = (CompletionProposalCategory)it.next();
            if (!category.isIncluded() || !category.hasComputers(this.fPartition)) continue;
            included.add(category);
        }
        return included;
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY)) {
            final Shell shell = DLTKUIPlugin.getActiveWorkbenchShell();
            String title = ScriptTextMessages.ContentAssistProcessor_all_disabled_title;
            String message = ScriptTextMessages.ContentAssistProcessor_all_disabled_message;
            final String restoreButtonLabel = JFaceResources.getString((String)"defaults");
            final String linkMessage = Messages.format(ScriptTextMessages.ContentAssistProcessor_all_disabled_preference_link, LegacyActionTools.removeMnemonics((String)restoreButtonLabel));
            OptionalMessageDialog dialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell, title, null, message, 4, new String[]{restoreButtonLabel, IDialogConstants.CLOSE_LABEL}, 1){

                protected Control createCustomArea(Composite composite) {
                    Composite parent = new Composite(composite, 0);
                    GridLayout layout = new GridLayout();
                    layout.marginHeight = 0;
                    layout.marginWidth = 0;
                    layout.verticalSpacing = 0;
                    parent.setLayout((Layout)layout);
                    Composite linkComposite = new Composite(parent, 0);
                    layout = new GridLayout();
                    layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                    layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                    layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                    linkComposite.setLayout((Layout)layout);
                    Link link = new Link(linkComposite, 0);
                    link.setText(linkMessage);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(this, shell){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            this.this$1.close();
                            PreferencesUtil.createPreferenceDialogOn((Shell)this.val$shell, (String)"org.eclipse.dltk.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
                        }
                    });
                    GridData gridData = new GridData(4, 1, true, false);
                    gridData.widthHint = this.getMinimumMessageWidth();
                    link.setLayoutData((Object)gridData);
                    super.createCustomArea(parent);
                    return parent;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    Button[] buttons = new Button[]{this.createButton(parent, 1034, restoreButtonLabel, false), this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true)};
                    this.setButtons(buttons);
                }
            };
            if (1034 == dialog.open()) {
                IPreferenceStore store = this.getPreferenceStore();
                store.setToDefault("content_assist_category_order");
                store.setToDefault("content_assist_disabled_computers");
                CompletionProposalComputerRegistry registry = CompletionProposalComputerRegistry.getDefault();
                registry.reload();
                return true;
            }
        }
        return false;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    private List getSeparateCategories() {
        ArrayList<CompletionProposalCategory> sorted = new ArrayList<CompletionProposalCategory>();
        Iterator it = this.fCategories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory category = (CompletionProposalCategory)it.next();
            if (!category.isSeparateCommand() || !category.hasComputers(this.fPartition)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, ORDER_COMPARATOR);
        return sorted;
    }

    private String createEmptyMessage() {
        return Messages.format(ScriptTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return Messages.format(ScriptTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration = repetition % this.fCategoryIteration.size();
        if (iteration == 0) {
            return ScriptTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString((CompletionProposalCategory)((List)this.fCategoryIteration.get(iteration)).get(0));
    }

    private String toString(CompletionProposalCategory category) {
        return category.getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? Messages.format(ScriptTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{binding.format()}) : ScriptTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc;
        TriggerSequence binding;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((binding = (bindingSvc = (IBindingService)iWorkbench.getAdapter((Class)clazz)).getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals")) instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }
}

