/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class RenameUserInterfaceStarter
extends UserInterfaceStarter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void activate(Refactoring refactoring, Shell parent, boolean save) throws CoreException {
        Object newElement;
        INameUpdating nameUpdating;
        RenameProcessor processor;
        Object[] elements;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ltk.core.refactoring.participants.RenameProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SelectionState state = (elements = (processor = (RenameProcessor)refactoring.getAdapter((Class)clazz)).getElements()).length == 1 ? new SelectionState(elements[0]) : null;
        super.activate(refactoring, parent, save);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.dltk.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((nameUpdating = (INameUpdating)refactoring.getAdapter((Class)clazz2)) != null && state != null && (newElement = nameUpdating.getNewElement()) != null) {
            state.restore(newElement);
        }
    }

    private static class SelectionState {
        private Display fDisplay;
        private Object fElement;
        private List fParts;
        private List fSelections;

        public SelectionState(Object element) {
            this.fElement = element;
            this.fParts = new ArrayList();
            this.fSelections = new ArrayList();
            this.init();
        }

        private void init() {
            IWorkbenchWindow dw = DLTKUIPlugin.getActiveWorkbenchWindow();
            if (dw == null) {
                return;
            }
            this.fDisplay = dw.getShell().getDisplay();
            IWorkbenchPage page = dw.getActivePage();
            if (page == null) {
                return;
            }
            IViewReference[] vrefs = page.getViewReferences();
            int i = 0;
            while (i < vrefs.length) {
                this.consider(vrefs[i].getPart(false));
                ++i;
            }
            IEditorReference[] refs = page.getEditorReferences();
            int i2 = 0;
            while (i2 < refs.length) {
                this.consider(refs[i2].getPart(false));
                ++i2;
            }
        }

        private void consider(IWorkbenchPart part) {
            ISelectionProvider selectionProvider;
            if (part == null) {
                return;
            }
            ISetSelectionTarget target = null;
            if (!(part instanceof ISetSelectionTarget)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((target = (ISetSelectionTarget)part.getAdapter((Class)clazz)) == null) {
                    return;
                }
            } else {
                target = (ISetSelectionTarget)part;
            }
            if ((selectionProvider = part.getSite().getSelectionProvider()) == null) {
                return;
            }
            ISelection s = selectionProvider.getSelection();
            if (!(s instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)s;
            if (!selection.toList().contains(this.fElement)) {
                return;
            }
            this.fParts.add(part);
            this.fSelections.add(selection);
        }

        public void restore(Object newElement) {
            if (this.fDisplay == null) {
                return;
            }
            int i = 0;
            while (i < this.fParts.size()) {
                IStructuredSelection currentSelection = (IStructuredSelection)this.fSelections.get(i);
                boolean changed = false;
                ISetSelectionTarget target = (ISetSelectionTarget)this.fParts.get(i);
                IStructuredSelection[] newSelection = new IStructuredSelection[]{currentSelection};
                if (currentSelection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)currentSelection;
                    TreePath[] paths = treeSelection.getPaths();
                    int p = 0;
                    while (p < paths.length) {
                        TreePath path = paths[p];
                        if (path.getSegmentCount() > 0 && path.getLastSegment().equals(this.fElement)) {
                            paths[p] = this.createTreePath(path, newElement);
                            changed = true;
                        }
                        ++p;
                    }
                    if (changed) {
                        newSelection[0] = new TreeSelection(paths, treeSelection.getElementComparer());
                    }
                } else {
                    Object[] elements = currentSelection.toArray();
                    int e = 0;
                    while (e < elements.length) {
                        if (elements[e].equals(this.fElement)) {
                            elements[e] = newElement;
                            changed = true;
                        }
                        ++e;
                    }
                    if (changed) {
                        newSelection[0] = new StructuredSelection(elements);
                    }
                }
                if (changed) {
                    this.fDisplay.asyncExec(new Runnable(this, target, newSelection){
                        final /* synthetic */ SelectionState this$1;
                        private final /* synthetic */ ISetSelectionTarget val$target;
                        private final /* synthetic */ IStructuredSelection[] val$newSelection;
                        {
                            this.this$1 = selectionState;
                            this.val$target = iSetSelectionTarget;
                            this.val$newSelection = iStructuredSelectionArray;
                        }

                        public void run() {
                            this.val$target.selectReveal((ISelection)this.val$newSelection[0]);
                        }
                    });
                }
                ++i;
            }
        }

        private TreePath createTreePath(TreePath old, Object newElement) {
            int count = old.getSegmentCount();
            Object[] newObjects = new Object[count];
            int i = 0;
            while (i < count - 1) {
                newObjects[i] = old.getSegment(i);
                ++i;
            }
            newObjects[count - 1] = newElement;
            return new TreePath(newObjects);
        }
    }
}

