/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.actions.refactoring.MoveAction;
import org.eclipse.dltk.internal.ui.actions.refactoring.RenameAction;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.eclipse.dltk.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.eclipse.dltk.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private static final String GROUP_REORG2 = "reorgGroup2";
    private static final String GROUP_TYPE2 = "typeGroup2";
    private IWorkbenchSite fSite;
    private ScriptEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private SelectionDispatchAction fModifyParametersAction;
    private SelectionDispatchAction fConvertAnonymousToNestedAction;
    private SelectionDispatchAction fConvertNestedToTopAction;
    private SelectionDispatchAction fPullUpAction;
    private SelectionDispatchAction fPushDownAction;
    private SelectionDispatchAction fExtractInterfaceAction;
    private SelectionDispatchAction fExtractSupertypeAction;
    private SelectionDispatchAction fChangeTypeAction;
    private SelectionDispatchAction fUseSupertypeAction;
    private SelectionDispatchAction fInferTypeArgumentsAction;
    private SelectionDispatchAction fInlineAction;
    private SelectionDispatchAction fIntroduceIndirectionAction;
    private SelectionDispatchAction fExtractMethodAction;
    private SelectionDispatchAction fExtractTempAction;
    private SelectionDispatchAction fExtractConstantAction;
    private SelectionDispatchAction fIntroduceParameterAction;
    private SelectionDispatchAction fIntroduceFactoryAction;
    private SelectionDispatchAction fConvertLocalToFieldAction;
    private SelectionDispatchAction fSelfEncapsulateField;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private final List fActions = new ArrayList();
    private Action fNoActionAvailable = new NoActionAvailable();
    static /* synthetic */ Class class$0;

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext workspaceContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)part.getViewSite(), workspaceContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public RefactorActionGroup(ScriptEditor editor, String groupName) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fRenameAction = new RenameAction(editor);
        this.initAction(this.fRenameAction, selection, "org.eclipse.dltk.ui.edit.text.script.rename.element");
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fMoveAction = new MoveAction(editor);
        this.initAction(this.fMoveAction, selection, "org.eclipse.dltk.ui.edit.text.script.move.element");
        editor.setAction("MoveElement", (IAction)this.fMoveAction);
        stats.endRun();
    }

    private RefactorActionGroup(IWorkbenchSite site) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fMoveAction = new MoveAction(site);
        this.initUpdatingAction(this.fMoveAction, provider, selection, "org.eclipse.dltk.ui.edit.text.script.move.element");
        this.fRenameAction = new RenameAction(site);
        this.initUpdatingAction(this.fRenameAction, provider, selection, "org.eclipse.dltk.ui.edit.text.script.rename.element");
        stats.endRun();
    }

    private void initAction(SelectionDispatchAction action, ISelection selection, String actionDefinitionId) {
        this.initUpdatingAction(action, null, selection, actionDefinitionId);
    }

    private void initUpdatingAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        action.update(selection);
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.fActions.add(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.Move", (IAction)this.fMoveAction);
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.Rename", (IAction)this.fRenameAction);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(actionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fSelfEncapsulateField, provider);
        this.disposeAction(this.fMoveAction, provider);
        this.disposeAction(this.fRenameAction, provider);
        this.disposeAction(this.fModifyParametersAction, provider);
        this.disposeAction(this.fPullUpAction, provider);
        this.disposeAction(this.fPushDownAction, provider);
        this.disposeAction(this.fExtractTempAction, provider);
        this.disposeAction(this.fExtractConstantAction, provider);
        this.disposeAction(this.fIntroduceParameterAction, provider);
        this.disposeAction(this.fIntroduceFactoryAction, provider);
        this.disposeAction(this.fExtractMethodAction, provider);
        this.disposeAction(this.fIntroduceIndirectionAction, provider);
        this.disposeAction(this.fInlineAction, provider);
        this.disposeAction(this.fExtractInterfaceAction, provider);
        this.disposeAction(this.fExtractSupertypeAction, provider);
        this.disposeAction(this.fChangeTypeAction, provider);
        this.disposeAction(this.fConvertNestedToTopAction, provider);
        this.disposeAction(this.fUseSupertypeAction, provider);
        this.disposeAction(this.fInferTypeArgumentsAction, provider);
        this.disposeAction(this.fConvertLocalToFieldAction, provider);
        this.disposeAction(this.fConvertAnonymousToNestedAction, provider);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = ActionMessages.RefactorMenu_label;
        MenuManager refactorSubmenu = new MenuManager(menuText, MENU_ID);
        if (this.fEditor != null) {
            IModelElement element = SelectionConverter.getInput((IEditorPart)this.fEditor);
            if (element != null && ActionUtil.isOnBuildPath(element)) {
                refactorSubmenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        RefactorActionGroup.this.refactorMenuShown(manager);
                    }
                });
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update(selection);
            }
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE2));
        return added;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 1;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        ModelTextSelection javaSelection = new ModelTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)javaSelection);
        }
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)textSelection);
        }
    }

    private IModelElement getEditorInput() {
        return DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(ActionMessages.RefactorActionGroup_noRefactoringAvailable);
        }
    }
}

