/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.tcl.core.TclKeywordsManager;
import org.eclipse.dltk.tcl.internal.ui.rules.TclCommentRule;
import org.eclipse.dltk.tcl.internal.ui.rules.TclFloatNumberRule;
import org.eclipse.dltk.tcl.internal.ui.rules.TclVariableRule;
import org.eclipse.dltk.tcl.internal.ui.text.TclWhitespaceDetector;
import org.eclipse.dltk.tcl.internal.ui.text.TclWordDetector;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class TclCodeScanner
extends AbstractScriptScanner {
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "tcl_variable"};
    private static String returnKeyword = "return";

    public TclCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = this.getToken("DLTK_keyword");
        Token comment = this.getToken("DLTK_single_line_comment");
        Token other = this.getToken("DLTK_default");
        Token variable = this.getToken("tcl_variable");
        Token number = this.getToken("DLTK_number");
        rules.add(new TclCommentRule((IToken)comment));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new TclWhitespaceDetector()));
        rules.add(new TclVariableRule((IToken)variable));
        rules.add(new TclFloatNumberRule((IToken)number));
        WordRule wordRule = new WordRule((IWordDetector)new TclWordDetector(), (IToken)other);
        String[] keywords = TclKeywordsManager.getKeywords();
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        Token returnToken = this.getToken("DLTK_keyword_return");
        wordRule.addWord(returnKeyword, (IToken)returnToken);
        rules.add(wordRule);
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

