/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PathDialog
extends StatusDialog {
    private IValidatorType fSelectedValidatorType;
    private StringDialogField fPath;
    private IEnvironment environment;
    private IStatus[] fStati;
    private int fPrevIndex = -1;

    public PathDialog(Shell shell, IEnvironment environment) {
        super(shell);
        this.environment = environment;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createDialogFields() {
        this.fPath = new StringDialogField();
        this.fPath.setLabelText("Path");
    }

    protected void createFieldListeners() {
        this.fPath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PathDialog.this.setPatternStatus(PathDialog.this.validate());
                PathDialog.this.updateStatusLine();
            }
        });
    }

    protected String getPattern() {
        return this.fPath.getText();
    }

    private void createLabel(Composite parent, String content, int columns) {
        Label l = new Label(parent, 0);
        l.setText(content);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = columns;
        l.setLayoutData((Object)gd);
    }

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fPath.doFillIntoGrid(parent, 3);
        ((GridData)this.fPath.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = true;
        this.initializeFields();
        this.createFieldListeners();
        PathDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void create() {
        super.create();
        this.fPath.setFocus();
    }

    private void initializeFields() {
        this.fPath.setText("");
        this.setPatternStatus(this.validate());
        this.updateStatusLine();
    }

    private IStatus validate() {
        String path = this.fPath.getText();
        StatusInfo info = new StatusInfo();
        if (path.length() == 0) {
            info.setError("Path is empty");
            return info;
        }
        IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)this.environment, (IPath)new Path(path));
        if (!file.exists()) {
            info.setError("File does not exists");
        } else if (!file.isDirectory()) {
            info.setError("File is not a directory");
        }
        return info;
    }

    public void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
    }

    private void setPatternStatus(IStatus status) {
        this.fStati[0] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    public void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_PATH_TCLCHECKER_DIALOG";
    }

    public String getPath() {
        return this.fPath.getText();
    }
}

