/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.folding;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ruby.internal.ui.RubyPreferenceConstants;
import org.eclipse.dltk.ruby.internal.ui.text.folding.RubyFoldingStructureProvider;
import org.eclipse.dltk.ruby.ui.tests.internal.RubyUITestsPlugin;
import org.eclipse.dltk.ruby.ui.tests.internal.TestUtils;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class RubyFoldingTest
extends TestCase {
    IPreferenceStore fStore;
    MyRubyASTFoldingStructureProvider provider;

    protected void setUp() throws Exception {
        super.setUp();
        this.fStore = RubyUITestsPlugin.getDefault().getPreferenceStore();
        RubyPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
        this.provider = new MyRubyASTFoldingStructureProvider();
    }

    public void test0() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = "#ab\n#dc\n";
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)1, (int)result.size());
    }

    public void test177924a() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = TestUtils.getData("resources/folding/b177924.rb");
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)3, (int)result.size());
    }

    public void test177924b() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 4);
        String content = TestUtils.getData("resources/folding/b177924.rb");
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)2, (int)result.size());
    }

    public void test193174a() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = TestUtils.getData("resources/folding/b193174.rb");
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.codeFolding = false;
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)27, (int)result.size());
    }

    public void test193174b() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = TestUtils.getData("resources/folding/b193174.rb");
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.commentFolding = false;
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)73, (int)result.size());
    }

    public void test193174c() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = TestUtils.getData("resources/folding/b193174.rb");
        Document document = new Document(content);
        TestUtils.installStuff(document);
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        RubyFoldingTest.assertEquals((int)100, (int)result.size());
    }

    private class MyRubyASTFoldingStructureProvider
    extends RubyFoldingStructureProvider {
        public boolean codeFolding = true;
        public boolean commentFolding = true;
        Document fDocument;

        private MyRubyASTFoldingStructureProvider() {
        }

        protected AbstractASTFoldingStructureProvider.FoldingStructureComputationContext createInitialContext() {
            this.initializePreferences(RubyFoldingTest.this.fStore);
            this.fCommentsFolding = this.commentFolding;
            return this.createContext(true);
        }

        protected AbstractASTFoldingStructureProvider.FoldingStructureComputationContext createContext(boolean allowCollapse) {
            ProjectionAnnotationModel model = new ProjectionAnnotationModel();
            IDocument doc = this.getDocument();
            if (doc == null) {
                return null;
            }
            return new AbstractASTFoldingStructureProvider.FoldingStructureComputationContext((AbstractASTFoldingStructureProvider)this, doc, model, allowCollapse);
        }

        public void setDocument(Document doc) {
            this.fDocument = doc;
        }

        protected IDocument getDocument() {
            return this.fDocument;
        }

        public Map testComputeFoldingStructure(String contents, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
            super.computeFoldingStructure(contents, ctx);
            return ctx.getMap();
        }

        protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
            return this.codeFolding && super.mayCollapse(s, ctx);
        }
    }
}

