/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.dltk.DLTKStructureBridge;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.ui.IEditorInput;

public class ActiveFoldingListener
extends AbstractContextListener {
    private final ScriptEditor editor;
    private IFoldingStructureProviderExtension updater;
    private static DLTKStructureBridge bridge;
    private boolean enabled;
    private Preferences.IPropertyChangeListener PREFERENCE_LISTENER;
    static /* synthetic */ Class class$0;

    public ActiveFoldingListener(ScriptEditor editor) {
        block10: {
            this.enabled = false;
            this.PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.dltk.mylyn.active.folding.enabled")) {
                        if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                            ActiveFoldingListener.this.enabled = true;
                        } else {
                            ActiveFoldingListener.this.enabled = false;
                        }
                        ActiveFoldingListener.this.updateFolding();
                    }
                }
            };
            this.editor = editor;
            bridge = new DLTKStructureBridge();
            ContextCorePlugin.getContextManager().addListener((AbstractContextListener)this);
            ContextUiPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
            this.enabled = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.mylyn.active.folding.enabled");
            try {
                Object adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = editor.getAdapter((Class)clazz)) instanceof IFoldingStructureProviderExtension) {
                    this.updater = (IFoldingStructureProviderExtension)adapter;
                    break block10;
                }
                StringBuffer stringBuffer = new StringBuffer("Could not install active folding on provider: ").append(adapter).append(", must extend ");
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                MylynStatusHandler.log(stringBuffer.append(clazz2.getName()).toString(), this);
            }
            catch (Exception e) {
                MylynStatusHandler.fail(e, "could not install auto folding, reflection denied", false);
            }
        }
        this.updateFolding();
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this);
        ContextUiPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public static void resetProjection(ScriptEditor dltk) {
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            this.editor.resetProjection();
        } else {
            if (this.editor.getEditorInput() == null) {
                return;
            }
            try {
                ArrayList<IModelElement> toExpand = new ArrayList<IModelElement>();
                ArrayList<IModelElement> toCollapse = new ArrayList<IModelElement>();
                ISourceModule element = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)this.editor.getEditorInput());
                if (element instanceof ISourceModule) {
                    ISourceModule compilationUnit = element;
                    List allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    ListIterator it = allChildren.listIterator();
                    while (it.hasNext()) {
                        IModelElement child = (IModelElement)it.next();
                        IInteractionElement mylarElement = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (mylarElement != null && mylarElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                if (this.updater != null) {
                    this.updater.collapseMembers();
                    this.updater.expandElements(toExpand.toArray(new IModelElement[toExpand.size()]));
                }
            }
            catch (Exception e) {
                MylynStatusHandler.fail(e, "couldn't update folding", false);
            }
        }
    }

    private static List getAllChildren(IParent parentElement) {
        ArrayList<IModelElement> allChildren = new ArrayList<IModelElement>();
        try {
            int i = 0;
            while (i < parentElement.getChildren().length) {
                IModelElement child = parentElement.getChildren()[i];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return allChildren;
    }

    public void interestChanged(List elements) {
        ListIterator it = elements.listIterator();
        while (it.hasNext()) {
            IInteractionElement element = (IInteractionElement)it.next();
            if (this.updater == null || !this.enabled) {
                return;
            }
            Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
            if (!(object instanceof IMember)) continue;
            IMember member = (IMember)object;
            if (element.getInterest().isInteresting()) {
                this.updater.expandElements(new IModelElement[]{member});
                try {
                    IModelElement[] childsChildren;
                    IModelElement[] children = member.getChildren();
                    if (children.length != 1) continue;
                    this.updater.expandElements(new IModelElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.updater.expandElements(new IModelElement[]{childsChildren[0]});
                }
                catch (ModelException modelException) {}
                continue;
            }
            this.updater.collapseElements(new IModelElement[]{member});
        }
    }

    public void contextActivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.mylyn.active.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.mylyn.active.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }

    public void contextCleared(IInteractionContext arg0) {
    }
}

