/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptWatchpoint
extends ScriptLineBreakpoint
implements IScriptWatchpoint {
    private static final String FIELD_NAME = "org.eclipse.dltk.debug.fieldName";
    private static final String ACCESS = "org.eclipse.dltk.debug.access";
    private static final String MODIFICATION = "org.eclipse.dltk.debug.modification";
    private static final String[] UPDATABLE_ATTRS = new String[]{"org.eclipse.dltk.debug.fieldName", "org.eclipse.dltk.debug.access", "org.eclipse.dltk.debug.modification"};

    public ScriptWatchpoint(String debugModelId, IResource resource, IPath path, int lineNumber, int start, int end, String fieldName) throws CoreException {
        super(debugModelId, resource, path, lineNumber, start, end, true);
        this.setFieldName(fieldName);
    }

    public ScriptWatchpoint() {
    }

    public String getFieldName() throws CoreException {
        return this.getMarker().getAttribute(FIELD_NAME, "");
    }

    public void setFieldName(String name) throws CoreException {
        this.getMarker().setAttribute(FIELD_NAME, (Object)name);
    }

    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptWatchPointMarker";
    }

    public boolean isAccess() throws CoreException {
        return new Boolean(this.getMarker().getAttribute(ACCESS, "true"));
    }

    public boolean isModification() throws CoreException {
        return new Boolean(this.getMarker().getAttribute(MODIFICATION, "true"));
    }

    public void setAccess(boolean access) throws CoreException {
        this.getMarker().setAttribute(ACCESS, (Object)Boolean.toString(access));
    }

    public void setModification(boolean modification) throws CoreException {
        this.getMarker().setAttribute(MODIFICATION, (Object)Boolean.toString(modification));
    }

    public boolean supportsAccess() {
        return true;
    }

    public boolean supportsModification() {
        return true;
    }

    public String[] getUpdatableAttributes() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(super.getUpdatableAttributes()));
        all.addAll(Arrays.asList(UPDATABLE_ATTRS));
        return all.toArray(new String[all.size()]);
    }
}

