/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptValue;

public class ScriptVariable
extends ScriptDebugElement
implements IScriptVariable {
    private final IDebugTarget target;
    private final IDbgpSession session;
    private final IScriptStackFrame frame;
    private final String name;
    private IDbgpProperty property;
    private IValue value;

    public ScriptVariable(IScriptStackFrame frame, IDbgpProperty property, String name) {
        this.target = frame.getDebugTarget();
        this.session = ((IScriptThread)frame.getThread()).getDbgpSession();
        this.name = name;
        this.property = property;
        this.frame = frame;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public synchronized IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = ScriptValue.createValue(this.frame, this.property);
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.property.getType();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public synchronized void setValue(String expression) throws DebugException {
        try {
            if (!(!"String".equals(this.property.getType()) || expression.startsWith("'") && expression.endsWith("'") || expression.startsWith("\"") && expression.endsWith("\""))) {
                expression = "\"" + expression.replaceAll("\\\"", "\\\\\"") + "\"";
            }
            if (this.session.getCoreCommands().setProperty(this.property.getEvalName(), this.frame.getLevel(), expression)) {
                this.clearEvaluationManagerCache();
                this.update();
            }
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException(Messages.ScriptVariable_cantAssignVariable, e);
        }
    }

    private void clearEvaluationManagerCache() {
        ScriptThread thread = (ScriptThread)this.frame.getThread();
        thread.notifyModified();
    }

    private void update() throws DbgpException {
        this.value = null;
        IDbgpCoreCommands core = this.session.getCoreCommands();
        String name = this.property.getEvalName();
        this.property = core.getProperty(name, this.frame.getLevel());
        DebugEventHelper.fireChangeEvent(this);
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        return !this.property.isConstant();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return expression != null;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean isConstant() {
        return this.property.isConstant();
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this.property.getKey();
    }
}

