/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.dbgp.commands.IDbgpBreakpointCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.Messages;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointUtils;

public class ScriptBreakpointManager
implements IBreakpointListener,
IBreakpointManagerListener {
    private static final int NO_CHANGES = 0;
    private static final int MINOR_CHANGE = 1;
    private static final int MAJOR_CHANGE = 2;
    private final IScriptDebugTarget target;

    protected static IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    protected static DbgpBreakpointConfig createBreakpointConfig(IScriptBreakpoint breakpoint) throws CoreException {
        boolean enabled = breakpoint.isEnabled() && ScriptBreakpointManager.getBreakpointManager().isEnabled();
        DbgpBreakpointConfig config = new DbgpBreakpointConfig(enabled);
        config.setHitValue(breakpoint.getHitValue());
        config.setHitCondition(breakpoint.getHitCondition());
        if (breakpoint.getExpressionState()) {
            config.setExpression(breakpoint.getExpression());
        }
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            config.setLineNo(lineBreakpoint.getLineNumber());
        }
        return config;
    }

    protected static String makeWatchpointExpression(IScriptWatchpoint watchpoint) throws CoreException {
        return String.valueOf(watchpoint.getFieldName()) + (watchpoint.isAccess() ? (char)'1' : '0') + (watchpoint.isModification() ? (char)'1' : '0');
    }

    protected static void addBreakpoint(IDbgpBreakpointCommands commands, IScriptBreakpoint breakpoint) throws CoreException, DbgpException {
        DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
        String id = null;
        if (breakpoint instanceof IScriptWatchpoint) {
            IScriptWatchpoint watchpoint = (IScriptWatchpoint)breakpoint;
            config.setExpression(ScriptBreakpointManager.makeWatchpointExpression(watchpoint));
            id = commands.setWatchBreakpoint(watchpoint.getResourceURI(), watchpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            if (entryBreakpoint.breakOnExit()) {
                String exitId = commands.setReturnBreakpoint(entryBreakpoint.getResourceURI(), entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setExitBreakpointId(exitId);
            }
            if (entryBreakpoint.breakOnEntry()) {
                String entryId = commands.setCallBreakpoint(entryBreakpoint.getResourceURI(), entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setEntryBreakpointId(entryId);
            }
        } else if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            id = ScriptBreakpointUtils.isConditional(lineBreakpoint) ? commands.setConditionalBreakpoint(lineBreakpoint.getResourceURI(), lineBreakpoint.getLineNumber(), config) : commands.setLineBreakpoint(lineBreakpoint.getResourceURI(), lineBreakpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptExceptionBreakpoint) {
            IScriptExceptionBreakpoint lineBreakpoint = (IScriptExceptionBreakpoint)breakpoint;
            id = commands.setExceptionBreakpoint(lineBreakpoint.getTypeName(), config);
        }
        breakpoint.setIdentifier(id);
    }

    protected static void changeBreakpoint(IDbgpBreakpointCommands commands, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryBreakpoint.breakOnEntry()) {
                if (entryId == null) {
                    entryId = commands.setCallBreakpoint(entryBreakpoint.getResourceURI(), entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setEntryBreakpointId(entryId);
                } else {
                    commands.updateBreakpoint(entryId, config);
                }
            } else if (entryId != null) {
                commands.removeBreakpoint(entryId);
                entryBreakpoint.setEntryBreakpointId(null);
            }
            String exitId = null;
            if (entryBreakpoint.breakOnExit()) {
                if (exitId == null) {
                    exitId = commands.setReturnBreakpoint(entryBreakpoint.getResourceURI(), entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setExitBreakpointId(exitId);
                } else {
                    commands.updateBreakpoint(exitId, config);
                }
            } else if (exitId != null) {
                commands.removeBreakpoint(exitId);
                entryBreakpoint.setExitBreakpointId(null);
            }
        } else {
            String id = breakpoint.getIdentifier();
            DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
            if (breakpoint instanceof IScriptWatchpoint) {
                config.setExpression(ScriptBreakpointManager.makeWatchpointExpression((IScriptWatchpoint)breakpoint));
            }
            commands.updateBreakpoint(id, config);
        }
    }

    protected static void removeBreakpoint(IDbgpBreakpointCommands commands, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        commands.removeBreakpoint(breakpoint.getIdentifier());
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            String exitId;
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryId != null) {
                commands.removeBreakpoint(entryId);
            }
            if ((exitId = entryBreakpoint.getExitBreakpointId()) != null) {
                commands.removeBreakpoint(exitId);
            }
        }
    }

    private static int hasChanges(IMarkerDelta delta, IScriptBreakpoint breakpoint) {
        String[] attrs = breakpoint.getUpdatableAttributes();
        try {
            IMarker marker = delta.getMarker();
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                Object oldValue = delta.getAttribute(attr);
                Object newValue = marker.getAttribute(attr);
                if (oldValue == null) {
                    if (newValue != null) {
                        return ScriptBreakpointManager.classifyChange(delta, breakpoint, attr);
                    }
                } else {
                    if (newValue == null) {
                        return ScriptBreakpointManager.classifyChange(delta, breakpoint, attr);
                    }
                    if (!oldValue.equals(newValue)) {
                        return ScriptBreakpointManager.classifyChange(delta, breakpoint, attr);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return 0;
    }

    private static int classifyChange(IMarkerDelta delta, IScriptBreakpoint breakpoint, String attr) throws CoreException {
        String oldExpr;
        boolean conditional = ScriptBreakpointUtils.isConditional(breakpoint);
        if (conditional && "org.eclipse.dltk.debug.expression".equals(attr)) {
            return 2;
        }
        boolean oldExprState = delta.getAttribute("org.eclipse.dltk.debug.expression.state", false);
        if (ScriptBreakpointUtils.isConditional(oldExprState, oldExpr = delta.getAttribute("org.eclipse.dltk.debug.expression", null)) != conditional) {
            return 2;
        }
        return 1;
    }

    protected void addBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IScriptThread[] threads;
        if (this.supportsBreakpoint(breakpoint) && (threads = (IScriptThread[])this.target.getThreads()).length > 0) {
            ScriptBreakpointManager.addBreakpoint(threads[0].getDbgpSession().getCoreCommands(), (IScriptBreakpoint)breakpoint);
        }
    }

    protected void changeBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IScriptThread[] threads;
        if (this.supportsBreakpoint(breakpoint) && (threads = (IScriptThread[])this.target.getThreads()).length > 0) {
            ScriptBreakpointManager.changeBreakpoint(threads[0].getDbgpSession().getCoreCommands(), (IScriptBreakpoint)breakpoint);
        }
    }

    protected void removeBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IScriptThread[] threads;
        if (this.supportsBreakpoint(breakpoint) && (threads = (IScriptThread[])this.target.getThreads()).length > 0) {
            ScriptBreakpointManager.removeBreakpoint(threads[0].getDbgpSession().getCoreCommands(), (IScriptBreakpoint)breakpoint);
        }
    }

    public ScriptBreakpointManager(IScriptDebugTarget target) {
        this.target = target;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptBreakpoint) {
            String modelId = this.target.getModelIdentifier();
            String breakpointModelId = breakpoint.getModelIdentifier();
            return breakpointModelId.equals(modelId);
        }
        return false;
    }

    public void setupDeferredBreakpoints() {
        IBreakpoint[] breakpoints = ScriptBreakpointManager.getBreakpointManager().getBreakpoints(this.target.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            block3: {
                try {
                    this.addBreakpoint(breakpoints[i]);
                }
                catch (Exception e) {
                    DLTKDebugPlugin.error(Messages.ErrorSetupDeferredBreakpoints, e);
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public String addBreakpoint(URI uri, int line) {
        try {
            IScriptThread[] threads = (IScriptThread[])this.target.getThreads();
            if (threads.length > 0) {
                IScriptThread thread = threads[0];
                DbgpBreakpointConfig config = new DbgpBreakpointConfig(true);
                return thread.getDbgpSession().getCoreCommands().setLineBreakpoint(uri, line, config);
            }
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    public void removeBreakpoint(String id) {
        try {
            IScriptThread[] threads = (IScriptThread[])this.target.getThreads();
            if (threads.length > 0) {
                IScriptThread thread = threads[0];
                thread.getDbgpSession().getCoreCommands().removeBreakpoint(id);
            }
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void setBreakpointUntilFirstSuspend(URI uri, int line) {
        final String tempId = this.addBreakpoint(uri, line);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (event.getKind() == 2) {
                        ScriptBreakpointManager.this.removeBreakpoint(tempId);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    ++i;
                }
            }
        });
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            this.addBreakpoint(breakpoint);
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            int changes;
            if (breakpoint instanceof IScriptBreakpoint && delta != null && (changes = ScriptBreakpointManager.hasChanges(delta, (IScriptBreakpoint)breakpoint)) != 0) {
                if (changes == 2) {
                    this.removeBreakpoint(breakpoint);
                    this.addBreakpoint(breakpoint);
                } else {
                    this.changeBreakpoint(breakpoint);
                }
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            this.removeBreakpoint(breakpoint);
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpointManager manager = ScriptBreakpointManager.getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(this.target.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            try {
                this.changeBreakpoint(breakpoints[i]);
            }
            catch (Exception e) {
                DLTKDebugPlugin.log(e);
            }
            ++i;
        }
    }
}

